/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.reflection;

import com.jdon.aop.reflection.MethodInvokerUtil;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.meta.MethodMetaArgs;
import com.jdon.bussinessproxy.target.TargetServiceFactory;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.util.Debug;
import java.lang.reflect.Method;

public class MethodConstructor {
    private static final String module = MethodConstructor.class.getName();
    private final MethodInvokerUtil methodInvokerUtil;
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;
    private final ContainerCallback containerCallback;

    public MethodConstructor(ContainerCallback containerCallback, TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.containerCallback = containerCallback;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
        this.methodInvokerUtil = new MethodInvokerUtil(targetMetaRequestsHolder);
    }

    public MethodInvokerUtil getMethodInvokerUtil() {
        return this.methodInvokerUtil;
    }

    public Method createMethod(TargetServiceFactory targetServiceFactory) {
        Method method = null;
        Debug.logVerbose("[JdonFramework] enter create the Method ", module);
        try {
            TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
            if (targetMetaRequest.getTargetMetaDef().isEJB()) {
                Object obj = this.methodInvokerUtil.createTargetObject(targetServiceFactory);
                method = this.createObjectMethod(obj, targetMetaRequest.getMethodMetaArgs());
            } else {
                method = this.createPojoMethod();
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] createMethod error: " + ex, module);
        }
        return method;
    }

    public Method createPojoMethod() {
        Method method = null;
        TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
        TargetMetaDef targetMetaDef = targetMetaRequest.getTargetMetaDef();
        MethodMetaArgs methodMetaArgs = targetMetaRequest.getMethodMetaArgs();
        Debug.logVerbose("[JdonFramework] createPOJO Method :" + methodMetaArgs.getMethodName() + " for target service: " + targetMetaDef.getName(), module);
        try {
            Class thisCLass = this.containerCallback.getContainerWrapper().getComponentClass(targetMetaDef.getName());
            if (thisCLass == null) {
                return null;
            }
            method = thisCLass.getMethod(methodMetaArgs.getMethodName(), methodMetaArgs.getParamTypes());
        }
        catch (NoSuchMethodException ne) {
            Debug.logError("[JdonFramework] method name:" + methodMetaArgs.getMethodName() + " or method parameters type don't match with your service's method", module);
            Class[] types = methodMetaArgs.getParamTypes();
            for (int i = 0; i < types.length; ++i) {
                Debug.logError("[JdonFramework]service's method parameter type must be:" + types[i] + "; ", module);
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] createPojoMethod error: " + ex, module);
        }
        return method;
    }

    public Method createObjectMethod(Object ownerClass, MethodMetaArgs methodMetaArgs) {
        Method m = null;
        try {
            m = ownerClass.getClass().getMethod(methodMetaArgs.getMethodName(), methodMetaArgs.getParamTypes());
        }
        catch (NoSuchMethodException nsme) {
            String errS = " NoSuchMethod:" + methodMetaArgs.getMethodName() + " in MethodMetaArgs of className:" + ownerClass.getClass().getName();
            Debug.logError(errS, module);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] createMethod error:" + ex, module);
        }
        return m;
    }

    public Method createObjectMethod(Object ownerClass, String methodName, Class[] paramTypes) {
        Method m = null;
        try {
            m = ownerClass.getClass().getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            String errS = " NoSuchMethod:" + methodName + " in className:" + ownerClass.getClass().getName() + " or method's args type error";
            Debug.logError(errS, module);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] createMethod error:" + ex, module);
        }
        return m;
    }
}

