/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.reflection;

import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.target.TargetServiceFactory;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.visitor.ComponentVisitor;
import com.jdon.util.Debug;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInvokerUtil {
    private static final String module = MethodInvokerUtil.class.getName();
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public MethodInvokerUtil(TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object execute(Method method, Object targetObj, Object[] p_args) throws Throwable {
        try {
            if (method == null || targetObj == null) {
                Debug.logError("[JdonFramework] no method or target, please check your configure", module);
            }
            if (p_args == null) {
                p_args = new Object[]{};
            }
            Debug.logVerbose("[JdonFramework] method invoke: " + targetObj.getClass().getName() + " method=" + method.getName(), module);
            Object result = method.invoke(targetObj, p_args);
            Debug.logVerbose("[JdonFramework] method invoke successfully ", module);
            return result;
        }
        catch (IllegalArgumentException iex) {
            String errorInfo = "Errors happened in your method:[" + targetObj.getClass().getName() + "." + method.getName() + "]";
            Debug.logError(errorInfo, module);
            errorInfo = "[JdonFramework] method invoke IllegalArgumentException: " + iex + " method argument type :[" + method.getParameterTypes() + "], but method arguments value p_args type:" + p_args.getClass().getName();
            Debug.logError(errorInfo, module);
            throw new Throwable(errorInfo, iex);
        }
        catch (InvocationTargetException ex) {
            Debug.logError(ex);
            String errorInfo = "Errors happened in your method:[" + targetObj.getClass().getName() + "." + method.getName() + "]";
            Debug.logError(errorInfo, module);
            throw new Throwable(errorInfo);
        }
        catch (IllegalAccessException ex) {
            String errorInfo = "Errors happened in your method:[" + targetObj.getClass().getName() + "." + method.getName() + "]";
            Debug.logError(errorInfo, module);
            Debug.logError("[JdonFramework] method invoke IllegalAccessException: " + ex, module);
            throw new Throwable("access method:" + method + " " + ex, ex);
        }
        catch (Exception ex) {
            String errorInfo = "Errors happened in your method:[" + targetObj.getClass().getName() + "." + method.getName() + "]";
            Debug.logError(errorInfo, module);
            Debug.logError("[JdonFramework] method invoke error: " + ex, module);
            throw new Throwable(" method invoke error: " + ex);
        }
    }

    public Object createTargetObject(TargetServiceFactory targetServiceFactory) {
        Debug.logVerbose("[JdonFramework] now getTargetObject by visitor ", module);
        Object targetObjRef = null;
        try {
            TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
            TargetMetaDef targetMetaDef = targetMetaRequest.getTargetMetaDef();
            if (targetMetaDef.isEJB()) {
                ComponentVisitor cm = targetMetaRequest.getComponentVisitor();
                targetMetaRequest.setVisitableName("targetServiceFactoryVisitable");
                Debug.logVerbose("targetServiceFactoryVisitable in action (cache)", module);
                targetObjRef = cm.visit();
            } else {
                Debug.logVerbose("[JdonFramework] not active targer service instance cache !!!!", module);
                targetObjRef = targetServiceFactory.create();
            }
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework]createTargetObject error: " + e, module);
        }
        return targetObjRef;
    }
}

