/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.EventResult;
import com.jdon.async.disruptor.ValueEvent;
import com.jdon.async.disruptor.ValueEventProcessor;
import com.jdon.domain.message.DomainMessage;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;

public class EventResultDisruptor
implements EventResult {
    protected String topic;
    protected DomainMessage domainMessage;
    protected boolean over;
    protected Object result;
    protected int timeoutforeturnResult = 10000;
    protected ValueEventProcessor valueEventProcessor;

    public EventResultDisruptor(String topic, DomainMessage domainMessage) {
        this.topic = topic;
        this.domainMessage = domainMessage;
        RingBuffer ringBuffer = new RingBuffer(ValueEvent.EVENT_FACTORY, (ClaimStrategy)new SingleThreadedClaimStrategy(8), (WaitStrategy)new BlockingWaitStrategy());
        this.valueEventProcessor = new ValueEventProcessor((RingBuffer<ValueEvent>)ringBuffer);
    }

    public void send(Object result) {
        this.valueEventProcessor.send(result);
    }

    public Object get() {
        if (this.over) {
            return this.result;
        }
        ValueEvent ve = this.valueEventProcessor.waitFor(this.timeoutforeturnResult);
        if (ve != null) {
            this.result = ve.getValue();
        }
        return this.result;
    }

    public Object getBlockedValue() {
        if (this.over) {
            return this.result;
        }
        ValueEvent ve = this.valueEventProcessor.waitForBlocking();
        if (ve != null) {
            this.result = ve.getValue();
        }
        return this.result;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getTimeoutforeturnResult() {
        return this.timeoutforeturnResult;
    }

    public void setWaitforTimeout(int timeoutforeturnResult) {
        this.timeoutforeturnResult = timeoutforeturnResult;
    }

    public void setOver(boolean over) {
        this.over = over;
    }
}

