/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.disruptor.ValueEvent;
import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueEventProcessor {
    protected RingBuffer<ValueEvent> ringBuffer;
    private long waitAtSequence = 0L;

    public ValueEventProcessor(RingBuffer<ValueEvent> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void send(Object result) {
        this.ringBuffer.setGatingSequences(new Sequence[]{new Sequence(-1L)});
        this.waitAtSequence = this.ringBuffer.next();
        ValueEvent ve = (ValueEvent)this.ringBuffer.get(this.waitAtSequence);
        ve.setValue(result);
        this.ringBuffer.publish(this.waitAtSequence);
    }

    public ValueEvent waitFor(long timeoutforeturnResult) {
        try {
            SequenceBarrier barrier = this.ringBuffer.newBarrier(new Sequence[0]);
            long a = barrier.waitFor(this.waitAtSequence, timeoutforeturnResult, TimeUnit.MILLISECONDS);
            return (ValueEvent)this.ringBuffer.get(a);
        }
        catch (AlertException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ValueEvent waitForBlocking() {
        try {
            SequenceBarrier barrier = this.ringBuffer.newBarrier(new Sequence[0]);
            long a = barrier.waitFor(this.waitAtSequence);
            ValueEvent ve = (ValueEvent)this.ringBuffer.get(a);
            return ve;
        }
        catch (AlertException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public long getWaitAtSequence() {
        return this.waitAtSequence;
    }

    public void setWaitAtSequence(long waitAtSequence) {
        this.waitAtSequence = waitAtSequence;
    }
}

