/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.future;

import com.jdon.async.EventResult;
import com.jdon.async.future.FutureListener;
import com.jdon.domain.message.DomainMessage;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class EventResultFuture
implements EventResult {
    protected String channel;
    protected boolean asyn;
    protected FutureListener messageListener;
    protected FutureTask futureTask;
    protected Object eventResult;
    protected boolean over;
    protected int timeoutforeturnResult = 10000;
    protected DomainMessage domainMessage;

    public EventResultFuture(String channel, final FutureListener messageListener, final DomainMessage domainMessage) {
        this.channel = channel;
        this.messageListener = messageListener;
        this.domainMessage = domainMessage;
        this.futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    messageListener.action(domainMessage);
                }
                catch (Exception e) {
                    System.err.println("[JdonFramework]asynExecMessageListener() error" + e + " message=" + EventResultFuture.this.getChannel() + " listener=" + messageListener.getClass().getName());
                    return false;
                }
                return true;
            }
        });
    }

    public Object get() {
        Object result = null;
        if (this.over) {
            return this.eventResult;
        }
        try {
            boolean runOk = (Boolean)this.futureTask.get(this.timeoutforeturnResult, TimeUnit.MILLISECONDS);
            if (runOk) {
                result = this.eventResult;
            }
            this.over = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getBlockedValue() {
        Object result = null;
        if (this.over) {
            return this.eventResult;
        }
        try {
            boolean runOk = (Boolean)this.futureTask.get();
            if (runOk) {
                result = this.eventResult;
            }
            this.over = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public void setAsyn(boolean asyn) {
        this.asyn = asyn;
    }

    public FutureListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(FutureListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setFutureTask(FutureTask futureTask) {
        this.futureTask = futureTask;
    }

    public void send(Object result) {
        this.eventResult = result;
    }

    public DomainMessage getDomainMessage() {
        return this.domainMessage;
    }

    public void setDomainMessage(DomainMessage domainMessage) {
        this.domainMessage = domainMessage;
    }

    public FutureTask getFutureTask() {
        return this.futureTask;
    }

    public void setWaitforTimeout(int timeoutforeturnResult) {
        this.timeoutforeturnResult = timeoutforeturnResult;
    }
}

