/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.task;

import com.jdon.async.task.MessageProcessor;
import com.jdon.async.task.Task;
import com.jdon.util.Debug;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;

public class TaskMonitor
extends Thread {
    private static final String module = TaskMonitor.class.getName();
    private ThreadPoolExecutor exec;
    private Semaphore semaphore;
    private MessageProcessor messageProcessor;

    public TaskMonitor(String taskExecCount, String MaxconcurrentTaskCount) {
        this.exec = (ThreadPoolExecutor)Executors.newFixedThreadPool(Integer.parseInt(taskExecCount));
        this.semaphore = new Semaphore(Integer.parseInt(MaxconcurrentTaskCount));
    }

    public void releaseSemaphore() {
        this.semaphore.release();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.messageProcessor == null) {
                        continue;
                    }
                    this.semaphore.acquire();
                    Task message = (Task)this.messageProcessor.getMessage();
                    this.exec.execute(new TaskWorker(message));
                    this.releaseSemaphore();
                }
            }
            catch (Exception e) {
                Debug.logError("[JdonFramework]run() error" + e, module);
                continue;
            }
            break;
        }
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void setMessageProcessor(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    class TaskWorker
    implements Runnable {
        protected Task to;

        public TaskWorker(Task to) {
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.to.action();
            }
            catch (Exception e) {
                Debug.logError("[JdonFramework]task run() error" + e + " task =" + this.to.getClass().getName(), module);
            }
        }
    }
}

