/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.bussinessproxy.dyncproxy;

import com.jdon.aop.AopClient;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.dyncproxy.DynamicProxyWeaving;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.visitor.Visitable;
import com.jdon.util.ClassUtil;
import com.jdon.util.Debug;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ProxyInstanceFactoryVisitable
implements Visitable {
    private static final String module = ProxyInstanceFactoryVisitable.class.getName();
    private final AopClient aopClient;
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public ProxyInstanceFactoryVisitable(AopClient aopClient, TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.aopClient = aopClient;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object accept() {
        Debug.logVerbose("[JdonFramework]enter Proxy.newProxyInstance ", module);
        Object dynamicProxy = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
            DynamicProxyWeaving dynamicProxyWeaving = new DynamicProxyWeaving(targetMetaRequest, this.aopClient);
            dynamicProxy = Proxy.newProxyInstance(classLoader, this.getInterfaces(targetMetaRequest.getTargetMetaDef()), (InvocationHandler)dynamicProxyWeaving);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] Proxy.newProxyInstance error:" + ex, module);
        }
        catch (Throwable ex) {
            Debug.logError("[JdonFramework] Proxy.newProxyInstance error:" + ex, module);
        }
        return dynamicProxy;
    }

    protected Class[] getInterfaces(TargetMetaDef targetMetaDef) {
        Class[] interfaces = targetMetaDef.getInterfaces();
        if (interfaces != null) {
            return interfaces;
        }
        try {
            interfaces = this.getPOJOInterfaces(targetMetaDef);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] getInterfaces error:" + ex, module);
        }
        catch (Throwable ex) {
            Debug.logError("[JdonFramework] getInterfaces error:" + ex, module);
        }
        if (interfaces == null || interfaces.length == 0) {
            Debug.logError("[JdonFramework] no find any interface for the service:" + targetMetaDef.getClassName(), module);
        } else {
            targetMetaDef.setInterfaces(interfaces);
            Debug.logVerbose("[JdonFramework]found the the below interfaces for the service:" + targetMetaDef.getClassName(), module);
            for (int i = 0; i < interfaces.length; ++i) {
                Debug.logVerbose(interfaces[i].getName() + ";", module);
            }
        }
        return interfaces;
    }

    public Class[] getPOJOInterfaces(TargetMetaDef targetMetaDef) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> pojoClass = null;
        try {
            pojoClass = classLoader.loadClass(targetMetaDef.getClassName());
        }
        catch (ClassNotFoundException e) {
            Debug.logError("[JdonFramework] getPOJOInterfaces error:" + e, module);
        }
        return ClassUtil.getParentAllInterfaces(pojoClass);
    }
}

