/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.cache;

import java.lang.ref.SoftReference;

public class CacheLine {
    private Object valueRef = null;
    private long loadTime = 0L;
    private boolean useSoftReference = false;

    public CacheLine(Object value, boolean useSoftReference) {
        this.useSoftReference = useSoftReference;
        this.valueRef = this.useSoftReference ? new SoftReference<Object>(value) : value;
    }

    public CacheLine(Object value, boolean useSoftReference, long loadTime) {
        this(value, useSoftReference);
        this.loadTime = loadTime;
    }

    public Object getValue() {
        if (this.valueRef == null) {
            return null;
        }
        if (this.useSoftReference) {
            return ((SoftReference)this.valueRef).get();
        }
        return this.valueRef;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public boolean isUseSoftReference() {
        return this.useSoftReference;
    }

    public void setUseSoftReference(boolean useSoftReference) {
        this.useSoftReference = useSoftReference;
    }
}

