/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.access;

import com.jdon.aop.AopClient;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.ServiceAccessor;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.visitor.ComponentVisitor;
import com.jdon.util.Debug;

public class ServiceAccessorImp
implements ServiceAccessor {
    private static final String module = ServiceAccessorImp.class.getName();
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public ServiceAccessorImp(TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object getService() {
        Debug.logVerbose("[JdonFramework] enter getService: proxyInstanceFactoryVisitable in action", module);
        TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
        targetMetaRequest.setVisitableName("proxyInstanceFactoryVisitable");
        ComponentVisitor componentVisitor = targetMetaRequest.getComponentVisitor();
        return componentVisitor.visit();
    }

    public Object executeService(ContainerWrapper cw) throws Exception {
        Debug.logVerbose("[JdonFramework]enter service execution core ", module);
        Object result = null;
        try {
            AopClient aopClient = (AopClient)cw.lookup("aopClient");
            result = aopClient.invoke();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] execute the service error: " + ex, module);
            throw new Exception("execute service error: " + ex);
        }
        catch (Throwable ex) {
            Debug.logError("[JdonFramework]  execute Service error: " + ex, module);
            throw new Exception("  execute Service error: " + ex);
        }
        return result;
    }
}

