/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation.type;

import com.jdon.annotation.Component;
import com.jdon.bussinessproxy.meta.POJOTargetMetaDef;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.type.AnnotationScaner;
import com.jdon.container.annotation.type.ConsumerLoader;
import com.jdon.container.annotation.type.Utils;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;
import com.jdon.util.UtilValidate;
import java.util.Set;

public class ComponentLoader {
    public static final String module = ComponentLoader.class.getName();
    AnnotationScaner annotationScaner;
    ConsumerLoader consumerLoader;

    public ComponentLoader(AnnotationScaner annotationScaner, ConsumerLoader consumerLoader) {
        this.annotationScaner = annotationScaner;
        this.consumerLoader = consumerLoader;
    }

    public void loadAnnotationComponents(AnnotationHolder annotationHolder, AppContextWrapper context, ContainerWrapper containerWrapper) {
        Set<String> classes = this.annotationScaner.getScannedAnnotations(context).get(Component.class.getName());
        if (classes == null) {
            return;
        }
        Debug.logVerbose("[JdonFramework] found Annotation components size:" + classes.size(), module);
        for (String className : classes) {
            this.createAnnotationComponentClass(className, annotationHolder, containerWrapper);
        }
    }

    public void createAnnotationComponentClass(String className, AnnotationHolder annotationHolder, ContainerWrapper containerWrapper) {
        try {
            Class cclass = Utils.createClass(className);
            Component cp = cclass.getAnnotation(Component.class);
            Debug.logVerbose("[JdonFramework] load Annotation component name:" + cclass.getName() + " class:" + className, module);
            String name = UtilValidate.isEmpty(cp.value()) ? cclass.getName() : cp.value();
            annotationHolder.addComponent(name, cclass);
            POJOTargetMetaDef pojoMetaDef = new POJOTargetMetaDef(name, className);
            annotationHolder.getTargetMetaDefHolder().add(name, pojoMetaDef);
            this.consumerLoader.loadMehtodAnnotations(cclass, containerWrapper);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] createAnnotationComponentClass error:" + e + className, module);
        }
    }
}

