/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation.type;

import com.jdon.annotation.Interceptor;
import com.jdon.bussinessproxy.meta.POJOTargetMetaDef;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.type.AnnotationScaner;
import com.jdon.container.annotation.type.Utils;
import com.jdon.container.interceptor.IntroduceInfoHolder;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;
import com.jdon.util.UtilValidate;
import java.util.Set;

public class InterceptorLoader {
    public static final String module = InterceptorLoader.class.getName();
    private AnnotationScaner annotationScaner;
    private IntroduceInfoHolder introduceInfoHolder;

    public InterceptorLoader(AnnotationScaner annotationScaner, IntroduceInfoHolder introduceInfoHolder) {
        this.annotationScaner = annotationScaner;
        this.introduceInfoHolder = introduceInfoHolder;
    }

    public void loadAnnotationInterceptors(AnnotationHolder annotationHolder, AppContextWrapper context) {
        Set<String> classes = this.annotationScaner.getScannedAnnotations(context).get(Interceptor.class.getName());
        if (classes == null) {
            return;
        }
        Debug.logVerbose("[JdonFramework] found Annotation Interceptor size:" + classes.size(), module);
        for (String className : classes) {
            this.createAnnotationInterceptor(className, annotationHolder);
        }
    }

    public void createAnnotationInterceptor(String className, AnnotationHolder annotationHolder) {
        try {
            Class cclass = Utils.createClass(className);
            Interceptor inter = cclass.getAnnotation(Interceptor.class);
            String name = cclass.getName();
            if (!UtilValidate.isEmpty(inter.value())) {
                name = inter.value();
            } else if (!UtilValidate.isEmpty(inter.name())) {
                name = inter.name();
            }
            annotationHolder.addComponent(name, cclass);
            annotationHolder.getInterceptors().put(name, cclass);
            if (!UtilValidate.isEmpty(inter.pointcut())) {
                String[] targets = inter.pointcut().split(",");
                for (int i = 0; i < targets.length; ++i) {
                    Class targetClass = annotationHolder.getComponentClass(targets[i]);
                    if (targetClass == null) continue;
                    this.introduceInfoHolder.addTargetClassNames(targetClass, targets[i]);
                }
            }
            POJOTargetMetaDef pojoMetaDef = new POJOTargetMetaDef(name, className);
            annotationHolder.getTargetMetaDefHolder().add(name, pojoMetaDef);
            Debug.logVerbose("[JdonFramework] load Annotation Interceptor name:" + name + " target class:" + className, module);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] createAnnotationInterceptorClass error:" + e + className, module);
        }
    }
}

