/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation.type;

import com.jdon.annotation.Service;
import com.jdon.annotation.Singleton;
import com.jdon.bussinessproxy.meta.POJOTargetMetaDef;
import com.jdon.bussinessproxy.meta.SingletonPOJOTargetMetaDef;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaDefHolder;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.type.AnnotationScaner;
import com.jdon.container.annotation.type.ConsumerLoader;
import com.jdon.container.annotation.type.Utils;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;
import com.jdon.util.UtilValidate;
import java.util.Set;

public class ServiceLoader {
    public static final String module = ServiceLoader.class.getName();
    AnnotationScaner annotationScaner;
    ConsumerLoader consumerLoader;

    public ServiceLoader(AnnotationScaner annotationScaner, ConsumerLoader consumerLoader) {
        this.annotationScaner = annotationScaner;
        this.consumerLoader = consumerLoader;
    }

    public void loadAnnotationServices(AnnotationHolder annotationHolder, AppContextWrapper context, ContainerWrapper containerWrapper) {
        Set<String> classes = this.annotationScaner.getScannedAnnotations(context).get(Service.class.getName());
        if (classes == null) {
            return;
        }
        Debug.logVerbose("[JdonFramework] found Annotation components size:" + classes.size(), module);
        for (String className : classes) {
            this.createAnnotationServiceClass(className, annotationHolder, containerWrapper);
        }
    }

    public void createAnnotationServiceClass(String className, AnnotationHolder annotationHolder, ContainerWrapper containerWrapper) {
        try {
            Class cclass = Utils.createClass(className);
            Service serv = cclass.getAnnotation(Service.class);
            Debug.logVerbose("[JdonFramework] load Annotation service name:" + serv.value() + " class:" + className, module);
            String name = UtilValidate.isEmpty(serv.value()) ? cclass.getName() : serv.value();
            annotationHolder.addComponent(name, cclass);
            this.createPOJOTargetMetaDef(name, className, annotationHolder.getTargetMetaDefHolder(), cclass);
            this.consumerLoader.loadMehtodAnnotations(cclass, containerWrapper);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] createAnnotationserviceClass error:" + e, module);
        }
    }

    public void createPOJOTargetMetaDef(String name, String className, TargetMetaDefHolder targetMetaDefHolder, Class cclass) {
        POJOTargetMetaDef pojoMetaDef = null;
        pojoMetaDef = cclass.isAnnotationPresent(Singleton.class) ? new SingletonPOJOTargetMetaDef(name, className) : new POJOTargetMetaDef(name, className);
        targetMetaDefHolder.add(name, pojoMetaDef);
    }
}

