/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.factory;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.annotation.AnnotationContainerBuilder;
import com.jdon.container.annotation.ContainerLoaderAnnotation;
import com.jdon.container.builder.ContainerRegistryBuilder;
import com.jdon.container.config.ContainerComponents;
import com.jdon.container.factory.ContainerFactory;
import com.jdon.container.factory.ContainerLoaderXML;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.controller.context.application.Application;

public class ContainerBuilderFactory {
    public static final String module = ContainerBuilderFactory.class.getName();
    private ContainerLoaderXML containerLoaderXML = new ContainerLoaderXML();
    private ContainerLoaderAnnotation containerLoaderAnnotation = new ContainerLoaderAnnotation();

    public synchronized ContainerRegistryBuilder createContainerBuilder(AppContextWrapper context) {
        this.containerLoaderAnnotation.startScan(context);
        ContainerFactory containerFactory = new ContainerFactory();
        ContainerWrapper cw = containerFactory.create(this.containerLoaderAnnotation.getConfigInfo());
        ContainerComponents configComponents = this.containerLoaderXML.loadAllContainerConfig(context);
        ContainerComponents aspectConfigComponents = this.containerLoaderXML.loadAllAspectConfig(context);
        return this.createContainerBuilder(context, cw, configComponents, aspectConfigComponents);
    }

    public synchronized ContainerRegistryBuilder createContainerBuilderForTest(String container_configFile, String aspect_configFile) {
        Application context = new Application();
        this.containerLoaderAnnotation.startScan(context);
        ContainerFactory containerFactory = new ContainerFactory();
        ContainerWrapper cw = containerFactory.create(this.containerLoaderAnnotation.getConfigInfo());
        ContainerComponents configComponents = this.containerLoaderXML.loadBasicComponents(container_configFile);
        ContainerComponents aspectConfigComponents = this.containerLoaderXML.loadAspectComponents(null, aspect_configFile);
        return this.createContainerBuilder(context, cw, configComponents, aspectConfigComponents);
    }

    public ContainerRegistryBuilder createContainerBuilder(AppContextWrapper context, ContainerWrapper cw, ContainerComponents configComponents, ContainerComponents aspectConfigComponents) {
        return new AnnotationContainerBuilder(context, cw, configComponents, aspectConfigComponents, this.containerLoaderAnnotation);
    }
}

