/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.factory;

import com.jdon.container.config.ContainerComponents;
import com.jdon.container.config.ContainerComponentsXmlLoader;
import com.jdon.container.config.aspect.AopInterceptorsXmlLoader;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;
import java.util.Map;

public class ContainerLoaderXML {
    public static final String module = ContainerLoaderXML.class.getName();
    private static final String DEFAULT_CONTAINER_CONFIGURE_FILENAME = "container.xml";
    private static final String DEFAULT_ASPECT_CONFIGURE_FILENAME = "aspect.xml";
    private static final String USER_CONTAINER_CONFIGURE_FILENAME = "mycontainer.xml";
    private static final String USER_ASPECT_CONFIGURE_FILENAME = "myaspect.xml";
    private static final String CONTAINER_CONFIG_PARAM = "containerConfigure";
    private static final String ASPECT_CONFIG_PARAM = "aspectConfigure";

    public ContainerComponents loadAllContainerConfig(AppContextWrapper context) {
        Debug.logVerbose("[JdonFramework] 1. read container components from:container.xml", module);
        ContainerComponents configComponents = this.loadBasicComponents(DEFAULT_CONTAINER_CONFIGURE_FILENAME);
        this.loadContextContainerConfig(configComponents, context);
        this.loadUserContainerConfig(configComponents, context);
        return configComponents;
    }

    public void loadContextContainerConfig(ContainerComponents configComponents, AppContextWrapper context) {
        String container_configFile = context.getInitParameter(CONTAINER_CONFIG_PARAM);
        if (container_configFile == null) {
            return;
        }
        Debug.logVerbose("[JdonFramework] 2. read container components from:" + container_configFile, module);
        ContainerComponents appconfigComponents = this.loadBasicComponents(container_configFile);
        configComponents.addComponents(appconfigComponents.getComponents());
    }

    public void loadUserContainerConfig(ContainerComponents configComponents, AppContextWrapper context) {
        Debug.logVerbose("[JdonFramework] 3. read container components from:mycontainer.xml", module);
        ContainerComponents userconfigComponents = this.loadBasicComponents(USER_CONTAINER_CONFIGURE_FILENAME);
        configComponents.addComponents(userconfigComponents.getComponents());
    }

    public ContainerComponents loadAllAspectConfig(AppContextWrapper context) {
        Debug.logVerbose("[JdonFramework]1. read apspect interceptors from:myaspect.xml", module);
        ContainerComponents aspectConfigComponents = this.loadAspectComponents(context, USER_ASPECT_CONFIGURE_FILENAME);
        this.loadContextAspectConfig(aspectConfigComponents, context);
        this.loadUserAspectConfig(aspectConfigComponents, context);
        return aspectConfigComponents;
    }

    public void loadContextAspectConfig(ContainerComponents aspectConfigComponents, AppContextWrapper context) {
        String aspect_configFile = context.getInitParameter(ASPECT_CONFIG_PARAM);
        if (aspect_configFile == null) {
            return;
        }
        Debug.logVerbose("[JdonFramework]2. read apspect interceptors from:" + aspect_configFile, module);
        ContainerComponents appaspectConfigComponents2 = this.loadAspectComponents(context, aspect_configFile);
        aspectConfigComponents.addComponents(appaspectConfigComponents2.getComponents());
    }

    public void loadUserAspectConfig(ContainerComponents aspectConfigComponents, AppContextWrapper context) {
        Debug.logVerbose("[JdonFramework] 3. read apspect interceptors from:aspect.xml", module);
        ContainerComponents aspectConfigComponents3 = this.loadAspectComponents(context, DEFAULT_ASPECT_CONFIGURE_FILENAME);
        aspectConfigComponents.addComponents(aspectConfigComponents3.getComponents());
        Debug.logVerbose("[JdonFramework] aspectConfigComponents size:" + aspectConfigComponents.size(), module);
    }

    public ContainerComponents loadBasicComponents(String configFile) {
        ContainerComponentsXmlLoader xmlParser = new ContainerComponentsXmlLoader();
        Map components = xmlParser.load(configFile);
        Debug.logVerbose("[JdonFramework] found components in " + configFile + " size:" + components.size(), module);
        ContainerComponents configComponents = new ContainerComponents(components);
        return configComponents;
    }

    public ContainerComponents loadAspectComponents(AppContextWrapper context, String configFile) {
        AopInterceptorsXmlLoader xmlParser = null;
        xmlParser = context != null ? new AopInterceptorsXmlLoader(context) : new AopInterceptorsXmlLoader();
        Map components = xmlParser.load(configFile);
        Debug.logVerbose("[JdonFramework] found aspect components in " + configFile + " size:" + components.size(), module);
        ContainerComponents configComponents = new ContainerComponents(components);
        return configComponents;
    }
}

