/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.interceptor;

import com.jdon.container.interceptor.IntroduceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceInfoHolder {
    public static final String NAME = IntroduceInfoHolder.class.getSimpleName();
    private Map<Class, IntroduceInfo> introduceInfos = new LinkedHashMap<Class, IntroduceInfo>();
    private Map<String, List<IntroduceInfo>> adviceNameIntroduceInfos;
    private Map<Class, String> introducerClassNames = new LinkedHashMap<Class, String>();

    public IntroduceInfoHolder() {
        this.adviceNameIntroduceInfos = new HashMap<String, List<IntroduceInfo>>();
    }

    public Map<Class, String> getAcceptorClassNames() {
        return this.introducerClassNames;
    }

    public Map<Class, IntroduceInfo> getIntroduceInfos() {
        return this.introduceInfos;
    }

    public IntroduceInfo getIntroduceInfoByIntroducer(Class introducerClass) {
        return this.introduceInfos.get(introducerClass);
    }

    public void addIntroduceInfo(String[] adviceNames, Class introducerClass) {
        if (adviceNames == null) {
            return;
        }
        for (int i = 0; i < adviceNames.length; ++i) {
            IntroduceInfo introduceInfo = new IntroduceInfo(adviceNames[i], introducerClass);
            this.introduceInfos.put(introducerClass, introduceInfo);
            this.addAdviceNameIntroduceInfos(adviceNames[i], introduceInfo);
        }
    }

    private void addAdviceNameIntroduceInfos(String adviceName, IntroduceInfo introduceInfo) {
        List<IntroduceInfo> infos = this.adviceNameIntroduceInfos.get(adviceName);
        if (infos == null) {
            infos = new ArrayList<IntroduceInfo>();
            this.adviceNameIntroduceInfos.put(adviceName, infos);
        }
        infos.add(introduceInfo);
    }

    public boolean containsThisClass(Class introducerClass) {
        return this.introduceInfos.containsKey(introducerClass);
    }

    public List<String> getIntroducerNameByIntroducedName(String introducedName) {
        ArrayList<String> names = new ArrayList<String>();
        List<IntroduceInfo> introduceInfos = this.adviceNameIntroduceInfos.get(introducedName);
        for (IntroduceInfo info : introduceInfos) {
            names.add(this.getTargetName(info.getTarget()));
        }
        return names;
    }

    public Set<String> getIntroduceNames() {
        return this.adviceNameIntroduceInfos.keySet();
    }

    public void addTargetClassNames(Class targetClass, String targetName) {
        this.introducerClassNames.put(targetClass, targetName);
    }

    public String getTargetName(Class targetClass) {
        return this.introducerClassNames.get(targetClass);
    }
}

