/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.pico;

import com.jdon.container.pico.ConfigInfo;
import com.jdon.container.pico.JdonComponentAdapterFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.VerifyingVisitor;

public class JdonPicoContainer
implements MutablePicoContainer,
ComponentMonitorStrategy,
Serializable {
    private static final long serialVersionUID = -1951644575769783030L;
    public static final String module = JdonPicoContainer.class.getName();
    private final Map componentKeyToAdapterCache = new ConcurrentHashMap();
    private final Map componentKeyToInstanceCache = new ConcurrentHashMap();
    private final List<ComponentAdapter> componentAdapters = new CopyOnWriteArrayList<ComponentAdapter>();
    private final HashSet children = new HashSet();
    private Set childrenStarted = new HashSet();
    private ComponentAdapterFactory componentAdapterFactory;
    private PicoContainer parent;
    private boolean started = false;
    private boolean disposed = false;

    public JdonPicoContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        if (componentAdapterFactory == null) {
            throw new NullPointerException("componentAdapterFactory");
        }
        this.componentAdapterFactory = componentAdapterFactory;
        this.parent = parent == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance((PicoContainer)parent);
    }

    public JdonPicoContainer(PicoContainer parent, ConfigInfo configInfo) {
        this(new JdonComponentAdapterFactory(configInfo), parent);
    }

    public JdonPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    public JdonPicoContainer(ConfigInfo configInfo) {
        this(new JdonComponentAdapterFactory(configInfo), null);
    }

    public Collection getComponentAdapters() {
        return Collections.unmodifiableList(this.componentAdapters);
    }

    public final ComponentAdapter getComponentAdapter(Object componentKey) throws AmbiguousComponentResolutionException {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            ComponentAdapter componentAdapter = (ComponentAdapter)found.get(i);
            foundClasses[i] = componentAdapter.getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.getComponentAdapters()) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        return found;
    }

    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        return adapter;
    }

    public ComponentAdapter registerComponentInstance(Object component) throws PicoRegistrationException {
        return this.registerComponentInstance(component.getClass(), component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        if (componentInstance instanceof MutablePicoContainer) {
            MutablePicoContainer pc = (MutablePicoContainer)componentInstance;
            Object contrivedKey = new Object();
            String contrivedComp = "";
            pc.registerComponentInstance(contrivedKey, (Object)contrivedComp);
            try {
                if (this.getComponentInstance(contrivedKey) != null) {
                    throw new PicoRegistrationException("Cannot register a container to itself. The container is already implicitly registered.");
                }
            }
            finally {
                pc.unregisterComponent(contrivedKey);
            }
        }
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance);
        this.registerComponent((ComponentAdapter)componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentKey, componentImplementation, (Parameter[])null);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoRegistrationException {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, List parameters) throws PicoRegistrationException {
        Parameter[] parametersAsArray = parameters.toArray(new Parameter[parameters.size()]);
        return this.registerComponentImplementation(componentKey, componentImplementation, parametersAsArray);
    }

    public List getComponentInstances() throws PicoException {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List getComponentInstancesOfType(Class componentType) throws PicoException {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<ComponentAdapter, Object> adapterToInstanceMap = new HashMap<ComponentAdapter, Object>();
        for (ComponentAdapter componentAdapter : this.componentAdapters) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            Object componentInstance = this.getInstance(componentAdapter);
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            result.add(componentInstance);
        }
        return result;
    }

    public Object getComponentInstance(Object componentKey) throws PicoException {
        ComponentAdapter componentAdapter = this.getComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return this.getInstance(componentAdapter);
        }
        return null;
    }

    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    public Object getInstance(ComponentAdapter componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        Object instance = this.componentKeyToInstanceCache.get(componentKey);
        if (instance == null && componentAdapter != null && (instance = this.getTrueInstance(componentAdapter)) != null) {
            this.componentKeyToInstanceCache.put(componentKey, instance);
        }
        return instance;
    }

    private Object getTrueInstance(ComponentAdapter componentAdapter) {
        boolean isLocal = this.componentAdapters.contains(componentAdapter);
        if (isLocal) {
            Object instance = componentAdapter.getComponentInstance((PicoContainer)this);
            return instance;
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        Collection componentAdapters = this.getComponentAdapters();
        for (ComponentAdapter componentAdapter : componentAdapters) {
            if (!this.getInstance(componentAdapter).equals(componentInstance)) continue;
            return this.unregisterComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse((Object)this);
    }

    public void start() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        Collection adapters = this.getComponentAdapters();
        for (ComponentAdapter componentAdapter : adapters) {
            if (!(componentAdapter instanceof LifecycleStrategy)) continue;
            ((LifecycleStrategy)componentAdapter).start(this.getInstance(componentAdapter));
        }
        this.childrenStarted.clear();
        for (PicoContainer child : this.children) {
            this.childrenStarted.add(new Integer(child.hashCode()));
            child.start();
        }
    }

    public void stop() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        for (PicoContainer child : this.children) {
            if (!this.childStarted(child)) continue;
            child.stop();
        }
        Collection adapters = this.getComponentAdapters();
        for (ComponentAdapter componentAdapter : adapters) {
            if (!(componentAdapter instanceof LifecycleStrategy)) continue;
            ((LifecycleStrategy)componentAdapter).stop(this.getInstance(componentAdapter));
        }
        this.started = false;
        this.componentKeyToAdapterCache.clear();
        this.componentKeyToInstanceCache.clear();
        this.componentAdapters.clear();
        this.children.clear();
        this.componentAdapterFactory = null;
        this.parent = null;
    }

    public void clearGurad() {
    }

    private boolean childStarted(PicoContainer child) {
        return this.childrenStarted.contains(new Integer(child.hashCode()));
    }

    public void dispose() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        for (PicoContainer child : this.children) {
            child.dispose();
        }
        Collection adapters = this.getComponentAdapters();
        for (ComponentAdapter componentAdapter : adapters) {
            if (!(componentAdapter instanceof LifecycleStrategy)) continue;
            ((LifecycleStrategy)componentAdapter).dispose(this.getInstance(componentAdapter));
        }
        this.disposed = true;
    }

    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer(this.componentAdapterFactory, (PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        return pc;
    }

    public boolean addChildContainer(PicoContainer child) {
        if (this.children.add(child)) {
            if (this.started) {
                this.childrenStarted.add(new Integer(child.hashCode()));
            }
            return true;
        }
        return false;
    }

    public boolean removeChildContainer(PicoContainer child) {
        boolean result = this.children.remove(child);
        return result;
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        ArrayList componentAdapters = new ArrayList(this.getComponentAdapters());
        for (ComponentAdapter componentAdapter : componentAdapters) {
            componentAdapter.accept(visitor);
        }
        ArrayList allChildren = new ArrayList(this.children);
        for (PicoContainer child : allChildren) {
            child.accept(visitor);
        }
    }

    public void changeMonitor(ComponentMonitor monitor) {
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)this.componentAdapterFactory).changeMonitor(monitor);
        }
        for (ComponentAdapter adapter : this.componentAdapters) {
            if (!(adapter instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)adapter).changeMonitor(monitor);
        }
        for (Object child : this.children) {
            if (!(child instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)child).changeMonitor(monitor);
        }
    }

    public ComponentMonitor currentMonitor() {
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)this.componentAdapterFactory).currentMonitor();
        }
        for (ComponentAdapter adapter : this.componentAdapters) {
            if (!(adapter instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)adapter).currentMonitor();
        }
        for (Object child : this.children) {
            if (!(child instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)child).currentMonitor();
        }
        throw new PicoIntrospectionException("No component monitor found in container or its children");
    }
}

