/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.startup;

import com.jdon.container.builder.ContainerDirector;
import com.jdon.container.builder.ContainerRegistryBuilder;
import com.jdon.container.factory.ContainerBuilderFactory;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;

public class ContainerSetupScript {
    public static final String module = ContainerSetupScript.class.getName();
    private final ContainerBuilderFactory containerBuilderContext = new ContainerBuilderFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialized(AppContextWrapper context) {
        ContainerRegistryBuilder cb = (ContainerRegistryBuilder)context.getAttribute("ContainerBuilder");
        if (cb != null) {
            return;
        }
        try {
            AppContextWrapper appContextWrapper = context;
            synchronized (appContextWrapper) {
                cb = this.containerBuilderContext.createContainerBuilder(context);
                context.setAttribute("ContainerBuilder", cb);
                Debug.logVerbose("[JdonFramework] Initialize the container OK ..");
            }
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] initialized error: " + e, module);
        }
    }

    public synchronized void prepare(String configureFileName, AppContextWrapper context) {
        try {
            ContainerRegistryBuilder cb = (ContainerRegistryBuilder)context.getAttribute("ContainerBuilder");
            if (cb == null) {
                this.initialized(context);
                cb = (ContainerRegistryBuilder)context.getAttribute("ContainerBuilder");
            }
            ContainerDirector cd = new ContainerDirector(cb);
            cd.prepareAppRoot(configureFileName);
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
        }
    }

    public synchronized void startup(AppContextWrapper context) {
        try {
            ContainerRegistryBuilder cb = (ContainerRegistryBuilder)context.getAttribute("ContainerBuilder");
            if (cb == null) {
                Debug.logError("[JdonFramework] at first call prepare method");
                return;
            }
            ContainerDirector cd = new ContainerDirector(cb);
            cd.startup();
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
        }
    }

    public void destroyed(AppContextWrapper context) {
        try {
            ContainerRegistryBuilder cb = (ContainerRegistryBuilder)context.getAttribute("ContainerBuilder");
            if (cb != null) {
                ContainerDirector cd = new ContainerDirector(cb);
                cd.shutdown();
                cb = null;
                context.setAttribute("ContainerBuilder", null);
                Debug.logVerbose("[JdonFramework] stop the container ..", module);
            }
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] destroyed error: " + e, module);
        }
    }
}

