/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.visitor;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.visitor.ComponentVisitor;
import com.jdon.container.visitor.Visitable;
import com.jdon.container.visitor.data.SessionContext;
import com.jdon.util.Debug;

public class ComponentOriginalVisitor
implements ComponentVisitor {
    private static final long serialVersionUID = 4109265173603639132L;
    private static final String module = ComponentOriginalVisitor.class.getName();
    private final ContainerCallback containerCallback;
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public ComponentOriginalVisitor(ContainerCallback containerCallback, TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.containerCallback = containerCallback;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object visit() {
        Object o = null;
        try {
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
            Debug.logVerbose("[JdonFramework] ComponentOriginalVisitor active:" + targetMetaRequest.getVisitableName(), module);
            Visitable vo = (Visitable)containerWrapper.lookup(targetMetaRequest.getVisitableName());
            o = vo.accept();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] ComponentOriginalVisitor active error: " + ex);
        }
        return o;
    }

    public SessionContext createSessionContext() {
        SessionContext sc = null;
        try {
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            Visitable vo = (Visitable)containerWrapper.lookup("sessionContextFactoryVisitable");
            sc = (SessionContext)vo.accept();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] ComponentOriginalVisitor createSessionContext error: " + ex);
        }
        return sc;
    }
}

