/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.cache;

import com.jdon.cache.CacheableWrapper;
import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.Cache;
import com.jdon.controller.cache.CacheKey;
import com.jdon.controller.cache.StringKey;
import com.jdon.util.Debug;

public class CacheManager
implements Startable {
    public static final String module = CacheManager.class.getName();
    private Cache cache;

    public CacheManager(Cache cache) {
        this.cache = cache;
    }

    public void start() {
        Debug.logVerbose("[JdonFramework]CacheFactory start .....", module);
        this.clear();
    }

    public void stop() {
        this.clear();
        this.cache = null;
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public Object fetchObject(StringKey skey) {
        Debug.logVerbose("[JdonFramework]<-cache->try to get cache: " + skey, module);
        return this.fetchObject(skey.getKey());
    }

    public Object fetchObject(String skey) {
        Debug.logVerbose("[JdonFramework]<-cache->try to get cache: " + skey, module);
        CacheableWrapper cw = (CacheableWrapper)this.cache.get(skey);
        if (cw != null) {
            Debug.logVerbose("[JdonFramework]<-cache->got it, hashcode=" + cw.hashCode(), module);
            return cw.getCachedValue();
        }
        return null;
    }

    public void putObect(CacheKey ckey, Object value) {
        if (ckey == null) {
            return;
        }
        if (this.cache.contain(ckey.getKey())) {
            return;
        }
        this.cache.put(ckey.getKey(), new CacheableWrapper(ckey.getDataKey(), value));
        Debug.logVerbose("[JdonFramework]<-cache->save cache: " + ckey.getKey() + ", cache size:" + this.cache.size(), module);
    }

    public void putObect(String skey, Object value) {
        if (skey == null) {
            return;
        }
        if (this.cache.contain(skey)) {
            return;
        }
        this.cache.put(skey, new CacheableWrapper(skey, value));
        Debug.logVerbose("[JdonFramework]<-cache->save cache: " + skey + ", cache size:" + this.cache.size(), module);
    }

    public void removeObect(StringKey skey) {
        if (skey == null || this.cache == null) {
            return;
        }
        this.cache.remove(skey.getKey());
        Debug.logVerbose("[JdonFramework]<-cache->remove the object of " + skey + " from cache", module);
    }

    public void removeObect(String skey) {
        if (skey == null) {
            return;
        }
        this.cache.remove(skey);
        Debug.logVerbose("[JdonFramework]<-cache->remove the object of " + skey + " from cache", module);
    }

    public void removeCache(Object dataKey) {
        if (dataKey == null) {
            return;
        }
        try {
            for (Object o : this.cache.keySet()) {
                CacheableWrapper cw;
                String key = (String)o;
                Object cachedValue = this.cache.get(key);
                if (!(cachedValue instanceof CacheableWrapper) || !(cw = (CacheableWrapper)cachedValue).getCachedValueKey().equals(dataKey.toString())) continue;
                this.removeObect(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cache getCache() {
        return this.cache;
    }
}

