/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.pool;

import com.jdon.bussinessproxy.target.TargetServiceFactory;
import com.jdon.controller.pool.CommonsPoolAdapter;
import com.jdon.util.Debug;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class CommonsPoolFactory
implements PoolableObjectFactory {
    private static final String module = CommonsPoolFactory.class.getName();
    private final TargetServiceFactory targetServiceFactory;
    private final CommonsPoolAdapter pool;

    public CommonsPoolFactory(TargetServiceFactory targetServiceFactory, String maxSize) {
        this.targetServiceFactory = targetServiceFactory;
        GenericObjectPool apachePool = new GenericObjectPool((PoolableObjectFactory)this);
        this.pool = new CommonsPoolAdapter(apachePool);
        if (maxSize == null) {
            Debug.logError("[JdonFramework] not set pool's max size", module);
        } else {
            int maxInt = Integer.parseInt(maxSize);
            this.pool.setMaxPoolSize(maxInt);
        }
    }

    public CommonsPoolAdapter getPool() {
        return this.pool;
    }

    public Object makeObject() {
        Object o = null;
        try {
            o = this.targetServiceFactory.create();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] Pool can not make object, error: " + ex, module);
        }
        return o;
    }

    public void destroyObject(Object o) throws Exception {
        this.targetServiceFactory.destroy();
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
    }

    public boolean validateObject(Object o) {
        return true;
    }
}

