/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.service;

import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.meta.MethodMetaArgs;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.UserTargetMetaDefFactory;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.controller.context.RequestWrapper;
import com.jdon.controller.service.Service;
import com.jdon.controller.service.WebServiceAccessor;
import com.jdon.util.Debug;

public class WebServiceImp
implements Service {
    private static final String module = WebServiceImp.class.getName();
    private final ContainerCallback containerCallback;
    private final WebServiceAccessor webServiceAccessor;
    private final UserTargetMetaDefFactory userTargetMetaDefFactory;

    public WebServiceImp(WebServiceAccessor webServiceAccessor, ContainerCallback containerCallback, UserTargetMetaDefFactory userTargetMetaDefFactory) {
        this.webServiceAccessor = webServiceAccessor;
        this.containerCallback = containerCallback;
        this.userTargetMetaDefFactory = userTargetMetaDefFactory;
    }

    public Object execute(String name, MethodMetaArgs methodMetaArgs, RequestWrapper request) throws Exception {
        if (methodMetaArgs == null || methodMetaArgs.getMethodName() == null) {
            Debug.logWarning(" methodMetaArgs is null. cann't invoke service.execute");
        }
        Debug.logVerbose("++++++++++++++++++++++++++++++<begin: invoking from jdonframework.xml", module);
        Debug.logVerbose("+++++++++++++++execute new service='" + name + "' method='" + methodMetaArgs.getMethodName() + "'", module);
        ContainerWrapper cw = this.containerCallback.getContainerWrapper();
        TargetMetaDef targetMetaDef = this.userTargetMetaDefFactory.getTargetMetaDef(name, cw);
        if (targetMetaDef == null) {
            return null;
        }
        Object result = this.execute(targetMetaDef, methodMetaArgs, request);
        Debug.logVerbose("+++++++++++++++execute service='" + name + "' method='" + methodMetaArgs.getMethodName() + "' successfully!", module);
        Debug.logVerbose("++++++++++++++++++++++++++++++<end:", module);
        return result;
    }

    public Object execute(TargetMetaDef targetMetaDef, MethodMetaArgs methodMetaArgs, RequestWrapper request) throws Exception {
        Debug.logVerbose("[JdonFramework]enter service execution core ", module);
        this.userTargetMetaDefFactory.createTargetMetaRequest(targetMetaDef, request.getContextHolder());
        TargetMetaRequest targetMetaRequest = this.userTargetMetaDefFactory.targetMetaRequestsHolder.getTargetMetaRequest();
        targetMetaRequest.setMethodMetaArgs(methodMetaArgs);
        return this.webServiceAccessor.execute(request);
    }
}

