/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.message;

import com.jdon.async.disruptor.EventDisruptor;
import com.jdon.container.ContainerWrapper;
import com.jdon.domain.message.DomainEventHandler;
import com.jdon.domain.message.consumer.ConsumerMethodHolder;
import com.jdon.util.Debug;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainEventDispatchHandler
implements DomainEventHandler<EventDisruptor> {
    public static final String module = DomainEventDispatchHandler.class.getName();
    private ConsumerMethodHolder consumerMethodHolder;
    private ContainerWrapper containerWrapper;
    private static final Map<Class<?>, Object> defaultValues = new HashMap();

    public DomainEventDispatchHandler(ConsumerMethodHolder consumerMethodHolder, ContainerWrapper containerWrapper) {
        this.consumerMethodHolder = consumerMethodHolder;
        this.containerWrapper = containerWrapper;
    }

    @Override
    public void onEvent(EventDisruptor event, boolean endOfBatch) throws Exception {
        try {
            Object parameter;
            Method method = this.consumerMethodHolder.getMethod();
            Class<?>[] pTypes = method.getParameterTypes();
            if (pTypes.length == 0) {
                Object o = this.containerWrapper.lookupOriginal(this.consumerMethodHolder.getClassName());
                method.invoke(o, new Object[0]);
            }
            if ((parameter = event.getDomainMessage().getEventSource()) == null) {
                Debug.logError("[Jdonframework]the publisher method with @Send need return type" + pTypes[0].getName(), module);
                return;
            }
            Object[] parameters = new Object[pTypes.length];
            int i = 0;
            for (Class<?> pType : pTypes) {
                parameters[i] = pType.isAssignableFrom(parameter.getClass()) ? parameter : (!pType.isPrimitive() ? pType.newInstance() : defaultValues.get(pType));
                ++i;
            }
            Object o = this.containerWrapper.lookupOriginal(this.consumerMethodHolder.getClassName());
            Object eventResult = method.invoke(o, parameters);
            event.getDomainMessage().setEventResult(eventResult);
        }
        catch (Exception e) {
            Debug.logError("[Jdonframework]" + this.consumerMethodHolder.getClassName() + " method with @onEvent error: " + e, module);
        }
    }

    static {
        defaultValues.put(String.class, "");
        defaultValues.put(Integer.class, 0);
        defaultValues.put(Integer.TYPE, 0);
        defaultValues.put(Long.class, 0L);
        defaultValues.put(Long.TYPE, 0L);
        defaultValues.put(Character.class, Character.valueOf('\u0000'));
        defaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

