/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.model.cache;

import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.CacheKey;
import com.jdon.controller.cache.CacheKeyFactory;
import com.jdon.controller.cache.CacheManager;
import com.jdon.controller.model.ModelUtil;
import com.jdon.domain.model.cache.ModelCacheKeyFactory;
import com.jdon.util.Debug;

public class ModelCacheManager
implements Startable {
    private static final String module = ModelCacheManager.class.getName();
    protected CacheManager cacheManager;
    private final CacheKeyFactory cacheKeyFactory;

    public ModelCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.cacheKeyFactory = new ModelCacheKeyFactory();
    }

    public void start() {
        Debug.logVerbose("[JdonFramework]ModelCacheManager start ...", module);
    }

    public void stop() {
        this.cacheManager.clear();
        this.cacheManager = null;
    }

    public Object getPModel(Class modelClass) {
        System.out.print("o=" + modelClass.getName());
        Class pClass = modelClass.getSuperclass();
        if (pClass == null) {
            return modelClass;
        }
        if (pClass.getName().equalsIgnoreCase(Object.class.getName())) {
            return modelClass;
        }
        return this.getPModel(pClass);
    }

    public void saveCache(Object dataKey, String modelClassName, Object model) {
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        this.saveToCache(cachKey, model);
    }

    protected void saveToCache(CacheKey cachKey, Object model) {
        Debug.logVerbose("[JdonFramework]save cache: " + cachKey + " hashCode:" + model.hashCode(), module);
        this.cacheManager.putObect(cachKey, model);
    }

    private Object getModelFromCache(CacheKey cachKey) {
        Object model = this.cacheManager.fetchObject(cachKey);
        if (model != null) {
            Debug.logVerbose("[JdonFramework]found cache: " + cachKey + " hashCode:" + model.hashCode(), module);
            if (ModelUtil.isModified(model)) {
                Debug.logWarning("[JdonFramework]<-cache-> model is isModified() cachKey=" + cachKey, module);
                this.removeCache(cachKey);
                model = null;
            }
        }
        return model;
    }

    public Object getCache(Object dataKey, String modelClassName) {
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        return this.getModelFromCache(cachKey);
    }

    public void removeCache(Object dataKey) {
        this.cacheManager.removeCache(dataKey);
    }

    public void removeCache2(Object dataKey, String modelClassName) {
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        this.cacheManager.removeObect(cachKey);
    }

    public void clearCache() {
        this.cacheManager.clear();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

