/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class FileLocator {
    public String getConfPathXmlFile(String filePathName) {
        int i = filePathName.lastIndexOf(".xml");
        String name = filePathName.substring(0, i);
        name = name.replace('.', '/');
        name = name + ".xml";
        return this.getConfFile(name);
    }

    public InputStream getConfPathXmlStream(String filePathName) {
        int i = filePathName.lastIndexOf(".xml");
        String name = filePathName.substring(0, i);
        name = name.replace('.', '/');
        name = name + ".xml";
        return this.getConfStream(name);
    }

    public String getConfFile(String fileName) {
        URL confURL;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((confURL = classLoader.getResource(fileName)) == null) {
            confURL = classLoader.getResource("META-INF/" + fileName);
        }
        if (confURL == null) {
            return null;
        }
        File file1 = new File(confURL.getFile());
        if (file1.isFile()) {
            System.out.println(" locate file: " + confURL.getFile());
            return confURL.getFile();
        }
        System.err.println(" it is not a file: " + confURL.getFile());
        return null;
    }

    public InputStream getConfStream(String fileName) {
        InputStream stream;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((stream = classLoader.getResourceAsStream(fileName)) == null) {
            stream = classLoader.getResourceAsStream("META-INF/" + fileName);
        }
        return stream;
    }
}

