/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ObjectCreator {
    private ObjectCreator() {
    }

    public static Object createObject(String className) throws Exception {
        return ObjectCreator.createObject(Class.forName(className));
    }

    public static Object createObject(Class classObject) throws Exception {
        return classObject.newInstance();
    }

    public static Object createObject(String className, Object[] params) throws Exception {
        return ObjectCreator.createObject(Class.forName(className), params);
    }

    public static Object createObject(Class classObject, Object[] params) throws Exception {
        Constructor<?>[] constructors = classObject.getConstructors();
        Object object = null;
        for (int counter = 0; counter < constructors.length; ++counter) {
            try {
                object = constructors[counter].newInstance(params);
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof InvocationTargetException)) continue;
                ((InvocationTargetException)e).getTargetException().printStackTrace();
            }
        }
        if (object == null) {
            throw new InstantiationException();
        }
        return object;
    }

    public static Class createClass(String className) {
        Class<?> classService = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            classService = classLoader.loadClass(className);
        }
        catch (Exception ex) {
            System.err.print("[JdonFramework] createClass error:" + ex);
        }
        return classService;
    }
}

