/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class RegisterCode {
    public Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public BufferedImage getBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    public BufferedImage getBufferedImage(InputStream in) throws Exception {
        return ImageIO.read(in);
    }

    public void create(int imageWidth, int imageHeight, String randNumber, String fontType, int fontSize, int x, int y, OutputStream out) {
        BufferedImage image = this.getBufferedImage(imageWidth, imageHeight);
        this.generate(image, randNumber, fontType, fontSize, x, y, out);
    }

    public void generate(BufferedImage image, String randNumber, String fontType, int fontSize, int x, int y, OutputStream out) {
        try {
            int width = image.getWidth();
            int height = image.getHeight();
            Graphics g = image.getGraphics();
            g.setColor(this.getRandColor(200, 250));
            g.fillRect(0, 0, width, height);
            g.setFont(new Font(fontType, 0, fontSize));
            g.setColor(this.getRandColor(160, 200));
            Random random = new Random();
            for (int i = 0; i < 155; ++i) {
                int x2 = random.nextInt(width);
                int y2 = random.nextInt(height);
                int x3 = random.nextInt(12);
                int y3 = random.nextInt(12);
                g.drawLine(x2, y2, x2 + x3, y2 + y3);
            }
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(randNumber, x, y);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", out);
        }
        catch (Exception ex) {
            System.err.println("generate image error: " + ex);
        }
    }
}

