/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestUtil {
    private static final String STOWED_REQUEST_ATTRIBS = "ssl.redirect.attrib.stowed";
    private static final String JDON_AUTOLOGIN_COOKIE = "jdon.autologin";
    private static final int ENCODE_XORMASK = 90;
    private static final char ENCODE_DELIMETER = '\u0002';
    private static final char ENCODE_CHAR_OFFSET1 = 'A';
    private static final char ENCODE_CHAR_OFFSET2 = 'h';

    public static String getRequestParameters(HttpServletRequest aRequest) {
        Map m = aRequest.getParameterMap();
        return RequestUtil.createQueryStringFromMap(m, "&").toString();
    }

    public static StringBuffer createQueryStringFromMap(Map m, String ampersand) {
        StringBuffer aReturn = new StringBuffer("");
        Set aEntryS = m.entrySet();
        for (Map.Entry aEntry : aEntryS) {
            Object o = aEntry.getValue();
            if (o == null) {
                RequestUtil.append(aEntry.getKey(), "", aReturn, ampersand);
                continue;
            }
            if (o instanceof String) {
                RequestUtil.append(aEntry.getKey(), o, aReturn, ampersand);
                continue;
            }
            if (o instanceof String[]) {
                String[] aValues = (String[])o;
                for (int i = 0; i < aValues.length; ++i) {
                    RequestUtil.append(aEntry.getKey(), aValues[i], aReturn, ampersand);
                }
                continue;
            }
            RequestUtil.append(aEntry.getKey(), o, aReturn, ampersand);
        }
        return aReturn;
    }

    private static StringBuffer append(Object key, Object value, StringBuffer queryString, String ampersand) {
        if (queryString.length() > 0) {
            queryString.append(ampersand);
        }
        queryString.append(RequestUtil.encodeURL(key.toString()));
        queryString.append("=");
        queryString.append(RequestUtil.encodeURL(value.toString()));
        return queryString;
    }

    public static void stowRequestAttributes(HttpServletRequest aRequest) {
        if (aRequest.getSession().getAttribute(STOWED_REQUEST_ATTRIBS) != null) {
            return;
        }
        Enumeration e = aRequest.getAttributeNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            map.put(name, aRequest.getAttribute(name));
        }
        aRequest.getSession().setAttribute(STOWED_REQUEST_ATTRIBS, map);
    }

    public static void reclaimRequestAttributes(HttpServletRequest aRequest) {
        Map map = (Map)aRequest.getSession().getAttribute(STOWED_REQUEST_ATTRIBS);
        if (map == null) {
            return;
        }
        for (String name : map.keySet()) {
            aRequest.setAttribute(name, map.get(name));
        }
        aRequest.getSession().removeAttribute(STOWED_REQUEST_ATTRIBS);
    }

    public static void saveAuthCookie(HttpServletResponse response, String username, String password) {
        RequestUtil.setCookie(response, JDON_AUTOLOGIN_COOKIE, RequestUtil.encodePasswordCookie(username, password), "/");
    }

    public static String[] getAuthCookie(HttpServletRequest request) {
        Cookie cookie = RequestUtil.getCookie(request, JDON_AUTOLOGIN_COOKIE);
        String[] values = null;
        if (cookie != null) {
            try {
                values = RequestUtil.decodePasswordCookie(cookie.getValue());
            }
            catch (Exception e) {
                System.err.print("getAuthCookie() err:" + e);
            }
        }
        return values;
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String path) {
        Cookie cookie = new Cookie(name, value);
        cookie.setSecure(false);
        cookie.setPath(path);
        cookie.setMaxAge(2592000);
        response.addCookie(cookie);
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        Cookie returnCookie = null;
        if (cookies == null) {
            return returnCookie;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie thisCookie = cookies[i];
            if (!thisCookie.getName().equals(name) || thisCookie.getValue().equals("")) continue;
            returnCookie = thisCookie;
            break;
        }
        return returnCookie;
    }

    public static void deleteCookie(HttpServletResponse response, Cookie cookie, String path) {
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setPath(path);
            response.addCookie(cookie);
        }
    }

    public static String getAppURL(HttpServletRequest request) {
        StringBuffer url = new StringBuffer();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        String scheme = request.getScheme();
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        return url.toString();
    }

    public static String encodeURL(String url) {
        return RequestUtil.encodeURL(url, "UTF-8");
    }

    public static String encodeURL(String url, String enc) {
        try {
            if (enc == null || enc.length() == 0) {
                enc = "UTF-8";
            }
            return URLEncoder.encode(url, enc);
        }
        catch (Exception e) {
            System.err.print(e);
            return null;
        }
    }

    private static String encodePasswordCookie(String username, String password) {
        StringBuffer buf = new StringBuffer();
        if (username != null && password != null) {
            byte[] bytes = (username + '\u0002' + password).getBytes();
            for (int n = 0; n < bytes.length; ++n) {
                int b = bytes[n] ^ 90 + n;
                buf.append((char)(65 + (b & 0xF)));
                buf.append((char)(104 + (b >> 4 & 0xF)));
            }
        }
        return buf.toString();
    }

    private static String[] decodePasswordCookie(String cookieVal) {
        if (cookieVal == null || cookieVal.length() <= 0) {
            return null;
        }
        char[] chars = cookieVal.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int m = 0;
        for (int n = 0; n < bytes.length; ++n) {
            int b = chars[m++] - 65;
            bytes[n] = (byte)((b |= chars[m++] - 104 << 4) ^ 90 + n);
        }
        cookieVal = new String(bytes);
        int pos = cookieVal.indexOf(2);
        String username = pos < 0 ? "" : cookieVal.substring(0, pos);
        String password = pos < 0 ? "" : cookieVal.substring(pos + 1);
        return new String[]{username, password};
    }
}

