/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class URLUtil {
    private URLConnection connection = null;
    private URL url = null;
    private boolean timedOut = false;

    protected URLUtil() {
    }

    protected URLUtil(URL url) {
        this.url = url;
    }

    protected synchronized URLConnection openConnection(int timeout) throws IOException {
        Thread t = new Thread(new URLConnectorThread());
        t.start();
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            if (this.connection == null) {
                this.timedOut = true;
            } else {
                URLUtil.close(this.connection);
            }
            throw new IOException("Connection never established");
        }
        if (this.connection != null) {
            return this.connection;
        }
        this.timedOut = true;
        throw new IOException("Connection timed out");
    }

    public static URLConnection openConnection(URL url) throws IOException {
        return URLUtil.openConnection(url, 30000);
    }

    public static URLConnection openConnection(URL url, int timeout) throws IOException {
        URLUtil uc = new URLUtil(url);
        return uc.openConnection(timeout);
    }

    private static void close(URLConnection con) {
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).disconnect();
        }
    }

    private class URLConnectorThread
    implements Runnable {
        private URLConnectorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            URLConnection con = null;
            try {
                con = URLUtil.this.url.openConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            URLUtil uRLUtil = URLUtil.this;
            synchronized (uRLUtil) {
                if (URLUtil.this.timedOut && con != null) {
                    URLUtil.close(con);
                } else {
                    URLUtil.this.connection = con;
                    URLUtil.this.notify();
                }
            }
        }
    }
}

