/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class UtilDateTime {
    private static final char[] zeroArray = "0000000000000000".toCharArray();

    public static Timestamp nowTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Date nowDate() {
        return new Date();
    }

    public static Timestamp getDayStart(Timestamp stamp) {
        return UtilDateTime.getDayStart(stamp, 0);
    }

    public static Timestamp getDayStart(Timestamp stamp, int daysLater) {
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(new Date(stamp.getTime()));
        tempCal.set(tempCal.get(1), tempCal.get(2), tempCal.get(5), 0, 0, 0);
        tempCal.add(5, daysLater);
        return new Timestamp(tempCal.getTime().getTime());
    }

    public static Timestamp getNextDayStart(Timestamp stamp) {
        return UtilDateTime.getDayStart(stamp, 1);
    }

    public static Timestamp getDayEnd(Timestamp stamp) {
        return UtilDateTime.getDayEnd(stamp, 0);
    }

    public static Timestamp getDayEnd(Timestamp stamp, int daysLater) {
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(new Date(stamp.getTime()));
        tempCal.set(tempCal.get(1), tempCal.get(2), tempCal.get(5), 23, 59, 59);
        tempCal.add(5, daysLater);
        return new Timestamp(tempCal.getTime().getTime());
    }

    public static java.sql.Date toSqlDate(String date) {
        Date newDate = UtilDateTime.toDate(date, "00:00:00");
        if (newDate != null) {
            return new java.sql.Date(newDate.getTime());
        }
        return null;
    }

    public static java.sql.Date toSqlDate(String monthStr, String dayStr, String yearStr) {
        Date newDate = UtilDateTime.toDate(monthStr, dayStr, yearStr, "0", "0", "0");
        if (newDate != null) {
            return new java.sql.Date(newDate.getTime());
        }
        return null;
    }

    public static java.sql.Date toSqlDate(int month, int day, int year) {
        Date newDate = UtilDateTime.toDate(month, day, year, 0, 0, 0);
        if (newDate != null) {
            return new java.sql.Date(newDate.getTime());
        }
        return null;
    }

    public static Time toSqlTime(String time) {
        Date newDate = UtilDateTime.toDate("1/1/1970", time);
        if (newDate != null) {
            return new Time(newDate.getTime());
        }
        return null;
    }

    public static Time toSqlTime(String hourStr, String minuteStr, String secondStr) {
        Date newDate = UtilDateTime.toDate("0", "0", "0", hourStr, minuteStr, secondStr);
        if (newDate != null) {
            return new Time(newDate.getTime());
        }
        return null;
    }

    public static Time toSqlTime(int hour, int minute, int second) {
        Date newDate = UtilDateTime.toDate(0, 0, 0, hour, minute, second);
        if (newDate != null) {
            return new Time(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(String dateTime) {
        Date newDate = UtilDateTime.toDate(dateTime);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(String date, String time) {
        Date newDate = UtilDateTime.toDate(date, time);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(String monthStr, String dayStr, String yearStr, String hourStr, String minuteStr, String secondStr) {
        Date newDate = UtilDateTime.toDate(monthStr, dayStr, yearStr, hourStr, minuteStr, secondStr);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Timestamp toTimestamp(int month, int day, int year, int hour, int minute, int second) {
        Date newDate = UtilDateTime.toDate(month, day, year, hour, minute, second);
        if (newDate != null) {
            return new Timestamp(newDate.getTime());
        }
        return null;
    }

    public static Date toDate(String dateTime) {
        String date = dateTime.substring(0, dateTime.indexOf(" "));
        String time = dateTime.substring(dateTime.indexOf(" ") + 1);
        return UtilDateTime.toDate(date, time);
    }

    public static Date toDate(String date, String time) {
        String second;
        String minute;
        if (date == null || time == null) {
            return null;
        }
        int dateSlash1 = date.indexOf("/");
        int dateSlash2 = date.lastIndexOf("/");
        if (dateSlash1 <= 0 || dateSlash1 == dateSlash2) {
            return null;
        }
        int timeColon1 = time.indexOf(":");
        int timeColon2 = time.lastIndexOf(":");
        if (timeColon1 <= 0) {
            return null;
        }
        String month = date.substring(0, dateSlash1);
        String day = date.substring(dateSlash1 + 1, dateSlash2);
        String year = date.substring(dateSlash2 + 1);
        String hour = time.substring(0, timeColon1);
        if (timeColon1 == timeColon2) {
            minute = time.substring(timeColon1 + 1);
            second = "0";
        } else {
            minute = time.substring(timeColon1 + 1, timeColon2);
            second = time.substring(timeColon2 + 1);
        }
        return UtilDateTime.toDate(month, day, year, hour, minute, second);
    }

    public static Date toDate(String monthStr, String dayStr, String yearStr, String hourStr, String minuteStr, String secondStr) {
        int second;
        int minute;
        int hour;
        int year;
        int day;
        int month;
        try {
            month = Integer.parseInt(monthStr);
            day = Integer.parseInt(dayStr);
            year = Integer.parseInt(yearStr);
            hour = Integer.parseInt(hourStr);
            minute = Integer.parseInt(minuteStr);
            second = Integer.parseInt(secondStr);
        }
        catch (Exception e) {
            return null;
        }
        return UtilDateTime.toDate(month, day, year, hour, minute, second);
    }

    public static Date toDate(int month, int day, int year, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.set(year, month - 1, day, hour, minute, second);
        }
        catch (Exception e) {
            return null;
        }
        return new Date(calendar.getTime().getTime());
    }

    public static String toDateString(Date date) {
        if (date == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int year = calendar.get(1);
        String monthStr = month < 10 ? "0" + month : "" + month;
        String dayStr = day < 10 ? "0" + day : "" + day;
        String yearStr = "" + year;
        return monthStr + "/" + dayStr + "/" + yearStr;
    }

    public static String toTimeString(Date date) {
        if (date == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return UtilDateTime.toTimeString(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static String toTimeString(int hour, int minute, int second) {
        String hourStr = hour < 10 ? "0" + hour : "" + hour;
        String minuteStr = minute < 10 ? "0" + minute : "" + minute;
        String secondStr = second < 10 ? "0" + second : "" + second;
        if (second == 0) {
            return hourStr + ":" + minuteStr;
        }
        return hourStr + ":" + minuteStr + ":" + secondStr;
    }

    public static String toDateTimeString(Date date) {
        if (date == null) {
            return "";
        }
        String dateString = UtilDateTime.toDateString(date);
        String timeString = UtilDateTime.toTimeString(date);
        if (dateString != null && timeString != null) {
            return dateString + " " + timeString;
        }
        return "";
    }

    public static Timestamp monthBegin() {
        Calendar mth = Calendar.getInstance();
        mth.set(5, 1);
        mth.set(11, 0);
        mth.set(12, 0);
        mth.set(13, 0);
        mth.set(9, 0);
        return new Timestamp(mth.getTime().getTime());
    }

    public static final String zeroPadString(String string, int length) {
        if (string == null || string.length() > length) {
            return string;
        }
        StringBuffer buf = new StringBuffer(length);
        buf.append(zeroArray, 0, length - string.length()).append(string);
        return buf.toString();
    }

    public static final String dateToMillis(long now) {
        return UtilDateTime.zeroPadString(Long.toString(now), 15);
    }

    public static String getDateTimeDisp(String datetime) {
        if (datetime == null || datetime.equals("")) {
            return "";
        }
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2);
        long datel = Long.parseLong(datetime);
        return formatter.format(new Date(datel));
    }
}

