/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util.jdom;

import com.jdon.util.jdom.DataUnformatFilter;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.XMLFilter;

public class XMLProperties {
    private Document doc;
    private Map propertyCache = new HashMap();

    public XMLProperties(String fileName) {
        try {
            SAXBuilder builder = new SAXBuilder();
            DataUnformatFilter format = new DataUnformatFilter();
            builder.setXMLFilter((XMLFilter)format);
            this.doc = builder.build(new File(fileName));
        }
        catch (Exception e) {
            System.err.println("Error creating XML parser in PropertyManager.java");
            e.printStackTrace();
        }
    }

    public XMLProperties(InputStream inputStream) {
        try {
            SAXBuilder builder = new SAXBuilder();
            DataUnformatFilter format = new DataUnformatFilter();
            builder.setXMLFilter((XMLFilter)format);
            this.doc = builder.build(inputStream);
        }
        catch (Exception e) {
            System.err.println("Error creating XML parser in PropertyManager.java");
            e.printStackTrace();
        }
    }

    public String getProperty(String name) {
        if (this.propertyCache.containsKey(name)) {
            return (String)this.propertyCache.get(name);
        }
        String[] propName = this.parsePropertyName(name);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if ((element = element.getChild(propName[i])) != null) continue;
            return null;
        }
        String value = element.getText();
        if ("".equals(value)) {
            return null;
        }
        value = value.trim();
        this.propertyCache.put(name, value);
        return value;
    }

    public String[] getChildrenProperties(String parent) {
        String[] propName = this.parsePropertyName(parent);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if ((element = element.getChild(propName[i])) != null) continue;
            return new String[0];
        }
        List children = element.getChildren();
        int childCount = children.size();
        String[] childrenNames = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            childrenNames[i] = ((Element)children.get(i)).getName();
        }
        return childrenNames;
    }

    public String[] getChildrenPropertiesValues(String parent) {
        String[] propName = this.parsePropertyName(parent);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if ((element = element.getChild(propName[i])) != null) continue;
            return new String[0];
        }
        List children = element.getChildren();
        int childCount = children.size();
        String[] childrenNames = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            childrenNames[i] = ((Element)children.get(i)).getValue();
        }
        return childrenNames;
    }

    public void setProperty(String name, String value) {
        this.propertyCache.put(name, value);
        String[] propName = this.parsePropertyName(name);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if (element.getChild(propName[i]) == null) {
                element.addContent((Content)new Element(propName[i]));
            }
            element = element.getChild(propName[i]);
        }
        element.setText(value);
    }

    public void deleteProperty(String name) {
        String[] propName = this.parsePropertyName(name);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.getChild(propName[i])) != null) continue;
            return;
        }
        element.removeChild(propName[propName.length - 1]);
    }

    private String[] parsePropertyName(String name) {
        int size = 1;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '.') continue;
            ++size;
        }
        String[] propName = new String[size];
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            propName[i] = tokenizer.nextToken();
            ++i;
        }
        return propName;
    }
}

