/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util.task;

import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class TaskEngine {
    private static LinkedList taskList = null;
    private static Thread[] workers = null;
    private static Timer taskTimer = null;
    private static Object lock = new Object();

    private TaskEngine() {
    }

    public static void addTask(Runnable r) {
        TaskEngine.addTask(r, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTask(Runnable task, int priority) {
        Object object = lock;
        synchronized (object) {
            taskList.addFirst(task);
            lock.notifyAll();
        }
    }

    public static TimerTask scheduleTask(Runnable task, long delay, long period) {
        ScheduledTask timerTask = new ScheduledTask(task);
        taskTimer.scheduleAtFixedRate((TimerTask)timerTask, delay, period);
        return timerTask;
    }

    public static TimerTask scheduleTask(Runnable task, int priority, long delay, long period) {
        ScheduledTask timerTask = new ScheduledTask(task, priority);
        taskTimer.scheduleAtFixedRate((TimerTask)timerTask, delay, period);
        return timerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Runnable nextTask() {
        Object object = lock;
        synchronized (object) {
            while (taskList.isEmpty()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (Runnable)taskList.removeLast();
        }
    }

    static {
        taskTimer = new Timer(true);
        workers = new Thread[7];
        taskList = new LinkedList();
        for (int i = 0; i < workers.length; ++i) {
            TaskEngineWorker worker = new TaskEngineWorker();
            TaskEngine.workers[i] = new Thread(worker);
            workers[i].setDaemon(true);
            workers[i].start();
        }
    }

    private static class ScheduledTask
    extends TimerTask {
        private Runnable task;

        public ScheduledTask(Runnable task) {
            this(task, 5);
        }

        public ScheduledTask(Runnable task, int priority) {
            this.task = task;
        }

        public void run() {
            TaskEngine.addTask(this.task);
        }
    }

    private static class TaskEngineWorker
    implements Runnable {
        private boolean done = false;

        private TaskEngineWorker() {
        }

        public void run() {
            while (!this.done) {
                TaskEngine.nextTask().run();
            }
        }
    }
}

