/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.config;

import com.jdon.controller.config.XmlParser;
import com.jdon.model.config.ModelMapping;
import com.jdon.model.handler.HandlerMetaDef;
import com.jdon.util.Debug;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class XmlModelParser
extends XmlParser {
    private static final String module = XmlModelParser.class.getName();

    public void parse(Element root, Map mps) throws Exception {
        try {
            List modelList = root.getChildren("models");
            for (Element models : modelList) {
                for (Element model : models.getChildren("model")) {
                    this.parseModelConfig(model, mps);
                }
            }
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework]parse models error: " + e), (String)module);
            throw new Exception(e);
        }
    }

    private void parseModelConfig(Element model, Map mps) throws Exception {
        try {
            ModelMapping modelMapping = new ModelMapping();
            modelMapping.setKeyName(model.getAttributeValue("key"));
            modelMapping.setClassName(model.getAttributeValue("class"));
            Debug.logVerbose((String)("[JdonFramework] read Config Model: " + modelMapping.getClassName()), (String)module);
            Debug.logVerbose((String)("[JdonFramework] key: " + modelMapping.getKeyName()), (String)module);
            Element actionFormE = model.getChild("actionForm");
            modelMapping.setFormName(actionFormE.getAttributeValue("name"));
            Debug.logVerbose((String)("[JdonFramework] actionForm name: " + modelMapping.getFormName()), (String)module);
            Element handlerE = model.getChild("handler");
            if (handlerE != null) {
                String classAttr = handlerE.getAttributeValue("class");
                if (classAttr != null) {
                    modelMapping.setHandler(classAttr);
                    Debug.logVerbose((String)("[JdonFramework] handler class: " + modelMapping.getHandler()), (String)module);
                }
                Debug.logVerbose((String)"[JdonFramework] look up service in handler: ", (String)module);
                HandlerMetaDef sm = new HandlerMetaDef();
                Element serviceE = handlerE.getChild("service");
                if (serviceE != null) {
                    this.parseHandlerConfig(serviceE, sm);
                    modelMapping.setHandlerMetaDef(sm);
                    sm.setModelMapping(modelMapping);
                }
            }
            mps.put(modelMapping.getFormName(), modelMapping);
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework]parse Model class:" + model.getAttributeValue("class") + " error: " + e), (String)module);
            throw new Exception(e);
        }
    }

    private void parseHandlerConfig(Element serviceE, HandlerMetaDef sm) throws Exception {
        Debug.logVerbose((String)"[JdonFramework] find a Service in handler: ", (String)module);
        try {
            Element deleteMethod;
            Element updateMethod;
            Element createMethod;
            Element getMethod;
            sm.setServiceRef(serviceE.getAttributeValue("ref"));
            Debug.logVerbose((String)("[JdonFramework] service ref: " + sm.getServiceRef()), (String)module);
            Element initMethod = serviceE.getChild("initMethod");
            if (initMethod != null) {
                sm.setInitMethod(initMethod.getAttributeValue("name"));
                Debug.logVerbose((String)("[JdonFramework] initMethod name: " + sm.getInitMethod()), (String)module);
            }
            if ((getMethod = serviceE.getChild("getMethod")) != null) {
                sm.setFindtMethod(getMethod.getAttributeValue("name"));
                Debug.logVerbose((String)("[JdonFramework] getMethod name: " + sm.getFindMethod()), (String)module);
            }
            if ((createMethod = serviceE.getChild("createMethod")) != null) {
                sm.setCreateMethod(createMethod.getAttributeValue("name"));
                Debug.logVerbose((String)("[JdonFramework] createMethod name: " + sm.getCreateMethod()), (String)module);
            }
            if ((updateMethod = serviceE.getChild("updateMethod")) != null) {
                sm.setUpdateMethod(updateMethod.getAttributeValue("name"));
                Debug.logVerbose((String)("[JdonFramework] updateMethod name: " + sm.getUpdateMethod()), (String)module);
            }
            if ((deleteMethod = serviceE.getChild("deleteMethod")) != null) {
                sm.setDeleteMethod(deleteMethod.getAttributeValue("name"));
                Debug.logVerbose((String)("[JdonFramework] deleteMethod name: " + sm.getDeleteMethod()), (String)module);
            }
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework]parseHandlerConfig error: " + e), (String)module);
            throw new Exception(e);
        }
    }
}

