/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.config;

import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.controller.config.DTDEntityResolver;
import com.jdon.util.Debug;
import com.jdon.util.FileLocator;
import com.jdon.util.UtilValidate;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlParser {
    private static final String module = XmlParser.class.getName();
    protected final FileLocator fileLocator = new FileLocator();

    public Map load(String configFileName) {
        LinkedHashMap<String, TargetMetaDef> mps = new LinkedHashMap<String, TargetMetaDef>();
        try {
            if (UtilValidate.isEmpty((String)configFileName)) {
                return mps;
            }
            Document doc = this.buildDocument(configFileName);
            if (doc == null) {
                return mps;
            }
            Element root = doc.getRootElement();
            this.parse(root, mps);
            Debug.logVerbose((String)"[JdonFramework]<!--   config load finished -->", (String)module);
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]configure FileName: " + configFileName + " parsed error: " + ex), (String)module);
        }
        return mps;
    }

    protected Document buildDocument(String configFileName) {
        Debug.logVerbose((String)("[JdonFramework] locate configure file  :" + configFileName), (String)module);
        Document doc = null;
        try {
            InputStream xmlStream = this.getInputStream(configFileName);
            if (xmlStream == null) {
                Debug.logVerbose((String)("[JdonFramework]can't locate file:" + configFileName), (String)module);
                return null;
            }
            Debug.logVerbose((String)("[JdonFramework] configure file found :" + xmlStream), (String)module);
            SAXBuilder builder = new SAXBuilder();
            builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
            doc = builder.build(xmlStream);
            Debug.logVerbose((String)"[JdonFramework] got mapping file ", (String)module);
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework] JDOMException error: " + e), (String)module);
        }
        return doc;
    }

    protected InputStream getInputStream(String configFileName) throws Exception {
        return this.fileLocator.getConfPathXmlStream(configFileName);
    }

    public abstract void parse(Element var1, Map<String, TargetMetaDef> var2) throws Exception;
}

