/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.config;

import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.meta.POJOTargetMetaDef;
import com.jdon.controller.config.XmlParser;
import com.jdon.util.Debug;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPojoServiceParser
extends XmlParser {
    private static final String module = XmlPojoServiceParser.class.getName();

    @Override
    public void parse(Element root, Map<String, TargetMetaDef> mps) throws Exception {
        Debug.logVerbose((String)"[JdonFramework] enter XmlPojoServiceParser .", (String)module);
        List services = root.getChildren("services");
        for (Element service : services) {
            if (service.getChildren("pojoService") != null) {
                for (Element pojoService : service.getChildren("pojoService")) {
                    this.parsePOJOServiceConfig(pojoService, mps);
                }
            }
            if (service.getChildren("component") == null) continue;
            for (Element pojoService : service.getChildren("component")) {
                this.parsePOJOServiceConfig(pojoService, mps);
            }
        }
    }

    private void parsePOJOServiceConfig(Element pojoService, Map<String, TargetMetaDef> mps) throws Exception {
        String name = pojoService.getAttributeValue("name");
        String className = pojoService.getAttributeValue("class");
        Debug.logVerbose((String)("[JdonFramework] pojoService/component name=" + name + " class=" + className), (String)module);
        if (className == null || className.equals("")) {
            throw new Exception("className is null ");
        }
        List mappings = pojoService.getChildren("constructor");
        String[] constructors = null;
        if (mappings != null && mappings.size() != 0) {
            Debug.logVerbose((String)("[JdonFramework] constructor parameters number:" + mappings.size() + " for pojoservice " + name), (String)module);
            constructors = new String[mappings.size()];
            int j = 0;
            for (Element constructor : mappings) {
                String value = constructor.getAttributeValue("value");
                Debug.logVerbose((String)("[JdonFramework] pojoService constructor=" + value), (String)module);
                constructors[j] = value;
                ++j;
            }
        }
        POJOTargetMetaDef pojoMetaDef = null;
        pojoMetaDef = constructors != null ? new POJOTargetMetaDef(name, className, constructors) : new POJOTargetMetaDef(name, className);
        mps.put(name, (TargetMetaDef)pojoMetaDef);
    }
}

