/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PageIterator
implements Iterator,
Serializable {
    private static final long serialVersionUID = -5131890503660837181L;
    public static final Object[] EMPTY = new Object[0];
    private int allCount = 0;
    private Object[] elements = EMPTY;
    private int currentIndex = -1;
    private Object nextElement = null;
    private Object previousElement = null;
    private int startIndex = -1;
    private int endIndex = -1;
    private int count = 0;
    private boolean elementsTypeIsKey = true;

    public PageIterator(int allCount, Object[] keys, int startIndex, int endIndex, int count) {
        this.allCount = allCount;
        this.elements = keys;
        if (startIndex >= 0) {
            this.startIndex = startIndex;
            this.currentIndex = startIndex - 1;
        }
        this.endIndex = endIndex;
        this.count = count;
    }

    public PageIterator(int allCount, Object[] keys) {
        this.allCount = allCount;
        this.elements = keys;
        this.endIndex = keys.length;
    }

    public PageIterator(int allCount, Object[] keys, int startIndex, boolean hasNextPage) {
        this(allCount, keys);
    }

    public PageIterator(Object[] keys, int startIndex, boolean hasNextPage) {
        this(0, keys);
    }

    public PageIterator() {
    }

    public int getAllCount() {
        return this.allCount;
    }

    public void setAllCount(int allCount) {
        this.allCount = allCount;
    }

    public void reset() {
        this.elements = EMPTY;
        this.currentIndex = -1;
        this.startIndex = -1;
        this.endIndex = -1;
        this.nextElement = null;
        this.previousElement = null;
        this.count = 0;
        this.allCount = 0;
    }

    public void setIndex(int index) {
        if (index >= this.startIndex || index < this.endIndex) {
            this.currentIndex = index;
        } else {
            System.err.println("PageIterator error: setIndex error: index=" + index + " exceed the 0 or Max length=" + this.elements.length);
        }
    }

    public boolean hasNext() {
        if (this.currentIndex == this.endIndex) {
            return false;
        }
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                return false;
            }
        }
        return true;
    }

    public Object next() throws NoSuchElementException {
        Object element = null;
        if (this.nextElement != null) {
            element = this.nextElement;
            this.nextElement = null;
        } else {
            element = this.getNextElement();
            if (element == null) {
                throw new NoSuchElementException();
            }
        }
        return element;
    }

    public boolean hasPrevious() {
        if (this.currentIndex == this.startIndex) {
            return false;
        }
        if (this.previousElement == null) {
            this.previousElement = this.getPreviousElement();
            if (this.previousElement == null) {
                return false;
            }
        }
        return true;
    }

    public Object previous() {
        Object element = null;
        if (this.previousElement != null) {
            element = this.previousElement;
            this.previousElement = null;
        } else {
            element = this.getPreviousElement();
            if (element == null) {
                throw new NoSuchElementException();
            }
        }
        return element;
    }

    private Object getPreviousElement() {
        Object element = null;
        while (this.currentIndex >= this.startIndex && element == null) {
            --this.currentIndex;
            element = this.getElement();
        }
        return element;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object getNextElement() {
        Object element = null;
        while (this.currentIndex + 1 < this.endIndex && element == null) {
            ++this.currentIndex;
            element = this.getElement();
        }
        return element;
    }

    private Object getElement() {
        Object element = null;
        if (this.currentIndex >= 0 && this.currentIndex < this.elements.length) {
            element = this.elements[this.currentIndex];
        } else {
            System.err.println("PageIterator error: currentIndex=" + this.currentIndex + " exceed the 0 or Max length=" + this.elements.length);
        }
        return element;
    }

    public int getSize() {
        return this.elements.length;
    }

    public Object[] getKeys() {
        return this.elements;
    }

    public void setKeys(Object[] keys) {
        this.elements = keys;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isElementsTypeIsKey() {
        return this.elementsTypeIsKey;
    }

    public void setElementsTypeIsKey(boolean elementsTypeIsKey) {
        this.elementsTypeIsKey = elementsTypeIsKey;
    }
}

