/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model;

import com.jdon.annotation.Component;
import com.jdon.domain.model.cache.ModelCacheManager;
import com.jdon.domain.model.cache.ModelKey;
import com.jdon.domain.model.injection.ModelProxyInjection;
import com.jdon.model.ModelHandler;
import com.jdon.model.ModelHandlerManager;
import com.jdon.model.config.ModelMapping;
import com.jdon.model.factory.ModelHandlerClassXMLBuilder;
import com.jdon.model.handler.HandlerObjectFactory;
import com.jdon.util.Debug;

@Component(value="modelHandlerManager")
public class ModelHandlerManagerImp
implements ModelHandlerManager {
    public static final String module = ModelHandlerManagerImp.class.getName();
    private final ModelHandlerClassXMLBuilder modelFactory;
    private final ModelCacheManager modelCacheManager;
    private final HandlerObjectFactory handlerObjectFactory;
    private final ModelProxyInjection modelProxyInjection;

    public ModelHandlerManagerImp(ModelHandlerClassXMLBuilder modelXmlLoader, ModelCacheManager modelCacheManager, HandlerObjectFactory handlerObjectFactory, ModelProxyInjection modelProxyInjection) {
        this.modelFactory = modelXmlLoader;
        this.modelCacheManager = modelCacheManager;
        this.handlerObjectFactory = handlerObjectFactory;
        this.modelProxyInjection = modelProxyInjection;
    }

    public ModelHandler borrowtHandlerObject(String formName) {
        ModelHandler modelHandler = null;
        try {
            modelHandler = this.handlerObjectFactory.borrowHandlerObject(formName);
            modelHandler.setModelMapping(this.modelFactory.getModelMapping(formName));
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]can't get the modelHandler for the formName " + formName), (String)module);
            this.returnHandlerObject(modelHandler);
        }
        return modelHandler;
    }

    public void returnHandlerObject(ModelHandler modelHandler) {
        if (modelHandler == null) {
            return;
        }
        try {
            this.handlerObjectFactory.returnHandlerObject(modelHandler);
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] return modelHandler error" + ex), (String)module);
        }
    }

    public Object getModelObject(String formName) {
        return this.makeModelObject(formName);
    }

    private Object makeModelObject(String formName) {
        Object object = null;
        Class modelClass = null;
        try {
            modelClass = this.modelFactory.getModelClasses(formName);
            if (modelClass == null) {
                throw new Exception(" not found the model in config xml, formName=" + formName);
            }
            object = modelClass.newInstance();
            this.modelProxyInjection.injectProperties(object);
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework]--> call Model: " + modelClass + " error:" + e), (String)module);
        }
        return object;
    }

    public void addCache(ModelKey modelKey, Object model) {
        if (modelKey == null || modelKey.getDataKey() == null) {
            return;
        }
        String modelClassName = null;
        try {
            if (modelKey.getModelClass() == null) {
                ModelMapping modelMapping = this.modelFactory.getModelMapping(modelKey.getFormName());
                modelClassName = modelMapping.getClassName();
            } else {
                modelClassName = modelKey.getModelClass().getName();
            }
            this.modelCacheManager.saveCache(modelKey.getDataKey(), modelClassName, model);
        }
        catch (Exception e) {
            Debug.logError((String)("addCache error:" + e), (String)module);
        }
    }

    public void addCache(Object key, String className, Object model) {
        if (key == null) {
            return;
        }
        this.modelCacheManager.saveCache(key, className, model);
    }

    public Object getCache(ModelKey modelKey) {
        String modelClassName = null;
        if (modelKey.getModelClass() == null) {
            ModelMapping modelMapping = this.modelFactory.getModelMapping(modelKey.getFormName());
            modelClassName = modelMapping.getClassName();
        } else {
            modelClassName = modelKey.getModelClass().getName();
        }
        return this.modelCacheManager.getCache(modelKey.getDataKey(), modelClassName);
    }

    public Object getCache(Object key, String className) {
        return this.modelCacheManager.getCache(key, className);
    }

    public void removeCache(Object dataKey) throws Exception {
        this.modelCacheManager.removeCache(dataKey);
    }

    public void clearCache() {
        this.modelCacheManager.clearCache();
    }

    public boolean isNull(String s) {
        boolean isNull = false;
        if (s == null) {
            isNull = true;
        } else if (s.equals("")) {
            isNull = true;
        } else if (s.equals("null")) {
            isNull = true;
        }
        return isNull;
    }
}

