/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.factory;

import com.jdon.annotation.Component;
import com.jdon.model.ModelHandler;
import com.jdon.model.config.ModelMapping;
import com.jdon.model.factory.ModelHandlerClassFactory;
import com.jdon.model.handler.HandlerMetaDef;
import com.jdon.util.Debug;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

@Component
public class ModelHandlerClassFactoryXmlImp
implements ModelHandlerClassFactory {
    private static final String module = ModelHandlerClassFactoryXmlImp.class.getName();
    private final ModelHandler modelHandler;

    public ModelHandlerClassFactoryXmlImp(ModelHandler modelHandler) {
        this.modelHandler = modelHandler;
    }

    public Class createModel(ModelMapping modelMapping) {
        Debug.logVerbose((String)"[JdonFramework]  create Model :", (String)module);
        String formName = modelMapping.getFormName();
        String className = modelMapping.getClassName();
        Class<?> newClass = null;
        try {
            Debug.logVerbose((String)("[JdonFramework]create model class, key=" + formName + " value=" + className), (String)module);
            newClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (newClass == null) {
                throw new Exception(" classLoader problem:  please check your config xml or check your pakcage");
            }
        }
        catch (Exception ex) {
            className = className.replaceAll(" ", "[ ]");
            Debug.logError((String)("[JdonFramework] className=" + className + " error:" + ex), (String)module);
        }
        return newClass;
    }

    public Class createModelKeyClassType(ModelMapping modelMapping, Class modelClass) {
        String keyName = modelMapping.getKeyName();
        Debug.logVerbose((String)("[JdonFramework]  createModelKeyClassType the keyName is  " + keyName), (String)module);
        return this.getKeyClassType(modelClass, keyName);
    }

    private Class getKeyClassType(Class beanClasses, String propertyName) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClasses);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                if (!pd.getName().equalsIgnoreCase(propertyName)) continue;
                Debug.logVerbose((String)("[JdonFramework]found the key Class Type==" + pd.getPropertyType().getName()), (String)module);
                return pd.getPropertyType();
            }
        }
        catch (Exception e) {
            Debug.logError((Throwable)e);
        }
        Debug.logVerbose((String)("[JdonFramework]not found the key Class Type, propertyName=" + propertyName), (String)module);
        return Object.class;
    }

    public Class createHandler(ModelMapping modelMapping) {
        Debug.logVerbose((String)"[JdonFramework] create Handler :", (String)module);
        String formName = modelMapping.getFormName();
        String handlerClassName = modelMapping.getHandler();
        HandlerMetaDef handlerMetaDef = modelMapping.getHandlerMetaDef();
        Class<?> newClass = null;
        try {
            if (handlerMetaDef != null && handlerClassName == null) {
                handlerClassName = this.modelHandler.getClass().getName();
                modelMapping.setHandler(handlerClassName);
                newClass = this.modelHandler.getClass();
            }
            if (handlerClassName != null) {
                newClass = Thread.currentThread().getContextClassLoader().loadClass(handlerClassName);
            }
            Debug.logVerbose((String)("[JdonFramework]create Handler class, key=" + formName + " value=" + handlerClassName), (String)module);
            if (newClass == null) {
                throw new Exception(" classLoader problem:  please check your config xml or check your pakcage");
            }
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework]  error:" + ex), (String)module);
        }
        return newClass;
    }
}

