/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.factory;

import com.jdon.annotation.Component;
import com.jdon.container.access.xml.AppConfigureCollection;
import com.jdon.container.pico.Startable;
import com.jdon.model.config.ConfigureReader;
import com.jdon.model.config.ModelMapping;
import com.jdon.model.factory.ModelHandlerClassFactory;
import com.jdon.util.Debug;
import java.util.HashMap;
import java.util.Map;

@Component
public final class ModelHandlerClassXMLBuilder
implements Startable {
    public static final String module = ModelHandlerClassXMLBuilder.class.getName();
    private final ModelHandlerClassFactory modelHandlerClassFactory;
    private final Map configLoadedList = new HashMap();
    private final Map mps = new HashMap();
    private final Map modelClasses = new HashMap();
    private final Map handlerClasses = new HashMap();

    public ModelHandlerClassXMLBuilder(AppConfigureCollection appConfigureFiles, ModelHandlerClassFactory handlerClassFactory) {
        this.modelHandlerClassFactory = handlerClassFactory;
        for (String configFile : appConfigureFiles.getConfigList()) {
            if (this.configLoadedList.containsKey(configFile)) continue;
            ConfigureReader configureReader = new ConfigureReader(configFile);
            Debug.logVerbose((String)("[JdonFramework]init configFile = " + configFile), (String)module);
            this.configLoadedList.put(configFile, configureReader);
        }
    }

    public void start() {
        try {
            for (String configFile : this.configLoadedList.keySet()) {
                Debug.logVerbose((String)("[JdonFramework] start configFile = " + configFile), (String)module);
                ConfigureReader configureLoader = (ConfigureReader)this.configLoadedList.get(configFile);
                Map modelMappings = configureLoader.load();
                this.mps.putAll(modelMappings);
                for (String formName : modelMappings.keySet()) {
                    this.build(formName);
                }
            }
            this.configLoadedList.clear();
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] !!!!!!!framework started error: " + ex), (String)module);
        }
    }

    private void build(String formName) {
        Debug.logVerbose((String)("[JdonFramework] start build model for formName = " + formName), (String)module);
        ModelMapping modelMapping = (ModelMapping)this.mps.get(formName);
        try {
            Class modelClass = this.modelHandlerClassFactory.createModel(modelMapping);
            this.modelClasses.put(formName, modelClass);
            Class keyClassType = this.modelHandlerClassFactory.createModelKeyClassType(modelMapping, modelClass);
            modelMapping.setKeyClassType(keyClassType);
            this.handlerClasses.put(formName, this.modelHandlerClassFactory.createHandler(modelMapping));
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework] build error: " + e), (String)module);
        }
    }

    public void stop() {
        this.mps.clear();
        this.configLoadedList.clear();
        this.modelClasses.clear();
        this.handlerClasses.clear();
    }

    public ModelMapping getModelMapping(String formName) {
        return (ModelMapping)this.mps.get(formName);
    }

    public Class getHandlerClasses(String formName) {
        return (Class)this.handlerClasses.get(formName);
    }

    public Class getModelClasses(String formName) {
        return (Class)this.modelClasses.get(formName);
    }
}

