/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.handler;

import com.jdon.annotation.Component;
import com.jdon.model.ModelHandler;
import com.jdon.model.factory.ModelHandlerClassXMLBuilder;
import com.jdon.util.Debug;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class HandlerObjectFactory {
    public static final String module = HandlerObjectFactory.class.getName();
    private final int poolSize = 50;
    private final ModelHandlerClassXMLBuilder modelHandlerClassBuilder;
    private final Map handlerFreePool = new ConcurrentHashMap();
    private final Map handlerUsedPool = new ConcurrentHashMap();

    public HandlerObjectFactory(ModelHandlerClassXMLBuilder modelXmlConfig) {
        this.modelHandlerClassBuilder = modelXmlConfig;
    }

    public ModelHandler borrowHandlerObject(String formName) {
        ModelHandler modelHandler = null;
        try {
            modelHandler = this.makeHandlerObject(formName);
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework]borrowHandlerObject error:" + e), (String)module);
        }
        return modelHandler;
    }

    private synchronized LinkedList makeHandlerObjects(String formName) throws Exception {
        Debug.logVerbose((String)"[JdonFramework]--> create Modelhandler instance 50", (String)module);
        ModelHandler modelHandler = null;
        LinkedList<ModelHandler> list = new LinkedList<ModelHandler>();
        for (int count = 0; count < 50; ++count) {
            modelHandler = this.makeHandlerObject(formName);
            list.add(modelHandler);
        }
        return list;
    }

    public void returnHandlerObject(ModelHandler modelHandler) {
    }

    private synchronized ModelHandler makeHandlerObject(String formName) throws Exception {
        ModelHandler object = null;
        Class handlerClass = null;
        try {
            handlerClass = this.modelHandlerClassBuilder.getHandlerClasses(formName);
            if (handlerClass == null) {
                throw new Exception(" not found the handler in config xml formName=" + formName);
            }
            object = (ModelHandler)handlerClass.newInstance();
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework]--> call Handler: " + handlerClass + " error:" + e), (String)module);
            throw new Exception(e);
        }
        return object;
    }
}

