/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.handler;

import com.jdon.annotation.Component;
import com.jdon.bussinessproxy.meta.MethodMetaArgs;
import com.jdon.controller.context.RequestWrapper;
import com.jdon.controller.context.web.HttpServletRequestWrapper;
import com.jdon.controller.events.EventModel;
import com.jdon.controller.service.Service;
import com.jdon.controller.service.ServiceFacade;
import com.jdon.model.ModelForm;
import com.jdon.model.ModelHandler;
import com.jdon.model.handler.HandlerMetaDef;
import com.jdon.model.handler.HandlerMethodMetaArgsFactory;
import com.jdon.util.Debug;
import javax.servlet.http.HttpServletRequest;

@Component
public class XmlModelHandler
extends ModelHandler {
    private static final String module = XmlModelHandler.class.getName();
    private final HandlerMethodMetaArgsFactory maFactory = new HandlerMethodMetaArgsFactory();
    private final ServiceFacade serviceFacade = new ServiceFacade();

    public Object initModelIF(EventModel em, ModelForm form, HttpServletRequest request) throws Exception {
        Object result = null;
        try {
            HandlerMetaDef hm = this.modelMapping.getHandlerMetaDef();
            String serviceName = hm.getServiceRef();
            Debug.logVerbose((String)("[JdonFramework] construct the CRUD method for the service:" + serviceName), (String)module);
            MethodMetaArgs methodMetaArgs = this.maFactory.createinitMethod(hm, em);
            HttpServletRequestWrapper requestW = new HttpServletRequestWrapper(request);
            Service service = this.serviceFacade.getService(requestW.getContextHolder().getAppContextHolder());
            if (methodMetaArgs != null) {
                result = service.execute(serviceName, methodMetaArgs, (RequestWrapper)requestW);
            }
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework] initModel error: " + e), (String)module);
            throw new Exception(e);
        }
        return result;
    }

    public Object findModelIF(Object keyValue, HttpServletRequest request) throws Exception {
        Object result = null;
        try {
            HandlerMetaDef hm = this.modelMapping.getHandlerMetaDef();
            String serviceName = hm.getServiceRef();
            Debug.logVerbose((String)("[JdonFramework] construct the CRUD method for the service:" + serviceName), (String)module);
            MethodMetaArgs methodMetaArgs = this.maFactory.createGetMethod(hm, keyValue);
            if (methodMetaArgs.getMethodName() == null) {
                throw new Exception("no configure findMethod value, but now you call it: ");
            }
            HttpServletRequestWrapper requestW = new HttpServletRequestWrapper(request);
            Service service = this.serviceFacade.getService(requestW.getContextHolder().getAppContextHolder());
            result = service.execute(serviceName, methodMetaArgs, (RequestWrapper)requestW);
        }
        catch (Exception e) {
            Debug.logError((String)("[JdonFramework] findModelByKey error: " + e + " maybe not configure getMethod"), (String)module);
            throw new Exception(e);
        }
        Debug.logVerbose((String)("[JdonFramework] result type:" + result.getClass().getName()), (String)module);
        return result;
    }

    public void serviceAction(EventModel em, HttpServletRequest request) throws Exception {
        Debug.logVerbose((String)"[JdonFramework] enter the serviceAction ", (String)module);
        try {
            HandlerMetaDef hm = this.modelMapping.getHandlerMetaDef();
            String serviceName = hm.getServiceRef();
            MethodMetaArgs methodMetaArgs = null;
            switch (em.getActionType()) {
                case 3: {
                    Debug.logVerbose((String)("[JdonFramework] construct the CRUD method for the service:" + serviceName), (String)module);
                    methodMetaArgs = this.maFactory.createCreateMethod(hm, em);
                    break;
                }
                case 2: {
                    Debug.logVerbose((String)("[JdonFramework] construct the CRUD method for the service:" + serviceName), (String)module);
                    methodMetaArgs = this.maFactory.createUpdateMethod(hm, em);
                    break;
                }
                case 4: {
                    Debug.logVerbose((String)("[JdonFramework] construct the CRUD method for the service:" + serviceName), (String)module);
                    methodMetaArgs = this.maFactory.createDeleteMethod(hm, em);
                    break;
                }
                default: {
                    Debug.logVerbose((String)("[JdonFramework] construct the command method for the service:" + serviceName), (String)module);
                    methodMetaArgs = this.maFactory.createDirectMethod(em.getActionName(), new Object[]{em});
                }
            }
            Debug.logVerbose((String)(" execute the method: " + methodMetaArgs.getMethodName() + " for the service: " + serviceName), (String)module);
            HttpServletRequestWrapper requestW = new HttpServletRequestWrapper(request);
            Service service = this.serviceFacade.getService(requestW.getContextHolder().getAppContextHolder());
            service.execute(serviceName, methodMetaArgs, (RequestWrapper)requestW);
        }
        catch (Exception ex) {
            Debug.logError((String)("[JdonFramework] serviceAction Error: " + ex), (String)module);
            throw new Exception(" serviceAction Error:" + ex);
        }
    }
}

