/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.query;

import com.jdon.model.query.JdbcUtil;
import com.jdon.util.DbUtil;
import com.jdon.util.Debug;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class JdbcTemp {
    private static final String module = JdbcTemp.class.getName();
    private final DataSource dataSource;
    private JdbcUtil jdbcUtil;

    public JdbcTemp(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcUtil = new JdbcUtil();
    }

    public Object querySingleObject(Collection queryParams, String sqlquery) throws Exception {
        Debug.logVerbose((String)"[JdonFramework]--> enter getSingleObject ", (String)module);
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        Object o = null;
        try {
            c = this.dataSource.getConnection();
            ps = c.prepareStatement(sqlquery, 1004, 1007);
            Debug.logVerbose((String)sqlquery, (String)module);
            this.jdbcUtil.setQueryParams(queryParams, (PreparedStatement)ps);
            rs = ps.executeQuery();
            if (rs.first()) {
                o = rs.getObject(1);
                Debug.logVerbose((String)("[JdonFramework]-->in db found it:" + o.getClass().getName()), (String)module);
            }
        }
        catch (SQLException se) {
            throw new SQLException("SQLException: " + se.getMessage());
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
            throw new Exception(ex);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (c != null) {
                c.close();
            }
        }
        return o;
    }

    public List queryMultiObject(Collection queryParams, String sqlquery) throws Exception {
        Debug.logVerbose((String)"[JdonFramework]--> enter queryMultiObject ", (String)module);
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        List list = new ArrayList();
        try {
            c = this.dataSource.getConnection();
            ps = c.prepareStatement(sqlquery, 1004, 1007);
            Debug.logVerbose((String)("[JdonFramework]" + sqlquery), (String)module);
            this.jdbcUtil.setQueryParams(queryParams, (PreparedStatement)ps);
            rs = ps.executeQuery();
            list = this.jdbcUtil.extract(rs);
        }
        catch (SQLException se) {
            throw new SQLException("SQLException: " + se.getMessage());
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
            throw new Exception(ex);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (c != null) {
                c.close();
            }
        }
        return list;
    }

    public List queryMultiObject(Collection queryParams, String sqlquery, int start, int count) throws Exception {
        Debug.logVerbose((String)("[JdonFramework]--> enter queryMultiObject from:" + start + " size:" + count), (String)module);
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        List items = new ArrayList(count);
        try {
            c = this.dataSource.getConnection();
            DbUtil.testConnection((Connection)c);
            ps = c.prepareStatement(sqlquery, 1004, 1007);
            Debug.logVerbose((String)sqlquery, (String)module);
            this.jdbcUtil.setQueryParams(queryParams, (PreparedStatement)ps);
            rs = ps.executeQuery();
            if (DbUtil.supportsFetchSize) {
                rs.setFetchSize(count);
            }
            if (start >= 0 && rs.absolute(start + 1)) {
                do {
                    items = this.jdbcUtil.extract(rs);
                } while (rs.next() && --count > 0);
            }
        }
        catch (SQLException se) {
            throw new SQLException("SQLException: " + se.getMessage());
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
            throw new Exception(ex);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (c != null) {
                c.close();
            }
        }
        return items;
    }

    public void operate(Collection insertParams, String sql) throws Exception {
        Debug.logVerbose((String)"[JdonFramework]--> enter getSingleObject ", (String)module);
        Connection c = null;
        Statement ps = null;
        try {
            c = this.dataSource.getConnection();
            ps = c.prepareStatement(sql);
            Debug.logVerbose((String)sql, (String)module);
            this.jdbcUtil.setQueryParams(insertParams, (PreparedStatement)ps);
            ps.executeUpdate();
        }
        catch (SQLException se) {
            throw new SQLException("SQLException: " + se.getMessage());
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
            throw new Exception(ex);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    public JdbcUtil getJdbcUtil() {
        return this.jdbcUtil;
    }

    public void setJdbcUtil(JdbcUtil jdbcUtil) {
        this.jdbcUtil = jdbcUtil;
    }
}

