/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.query;

import com.jdon.util.Debug;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class JdbcUtil {
    private static final String module = JdbcUtil.class.getName();

    public void setQueryParams(Collection queryParams, PreparedStatement ps) throws Exception {
        if (queryParams == null || queryParams.size() == 0) {
            return;
        }
        int i = 1;
        Object key2 = null;
        for (Object key2 : queryParams) {
            if (key2 != null) {
                this.convertType(i, key2, ps);
                Debug.logVerbose((String)("[JdonFramework] parameter " + i + " = " + key2.toString()), (String)module);
            } else {
                Debug.logWarning((String)("[JdonFramework] parameter " + i + " is null"), (String)module);
                ps.setString(i, "");
            }
            ++i;
        }
    }

    protected void convertType(int i, Object key, PreparedStatement ps) {
        try {
            if (key instanceof String) {
                String keyStrs = (String)key;
                ps.setString(i, keyStrs);
            } else if (key instanceof Integer) {
                ps.setInt(i, (Integer)key);
            } else if (key instanceof Float) {
                ps.setFloat(i, ((Float)key).floatValue());
            } else if (key instanceof Long) {
                ps.setLong(i, (Long)key);
            } else if (key instanceof Double) {
                ps.setDouble(i, (Double)key);
            } else if (key instanceof Byte) {
                ps.setByte(i, (Byte)key);
            } else if (key instanceof Short) {
                ps.setShort(i, (Short)key);
            } else if (key instanceof BigDecimal) {
                ps.setBigDecimal(i, (BigDecimal)key);
            } else {
                ps.setObject(i, key);
                Debug.logVerbose((String)("[JdonFramework]warning: Type =" + key.getClass().getName() + " isn't be converted!"), (String)module);
            }
        }
        catch (SQLException e) {
            Debug.logError((String)("[JdonFramework]setQueryParams error " + e + "in parameter order=" + i + " its value=" + key), (String)module);
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)module);
        }
    }

    public List extract(ResultSet rs) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        int count = meta.getColumnCount();
        ArrayList ret = new ArrayList();
        while (rs.next()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(count);
            for (int i = 1; i <= count; ++i) {
                map.put(meta.getColumnName(i), rs.getObject(i));
            }
            ret.add(map);
        }
        return ret;
    }
}

