/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.model.query.block;

import com.jdon.model.query.JdbcUtil;
import com.jdon.model.query.block.BlockQueryJDBC;
import com.jdon.model.query.cache.QueryConditonDatakey;
import com.jdon.util.DbUtil;
import com.jdon.util.Debug;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class BlockQueryJDBCTemp
implements BlockQueryJDBC {
    private static final String module = BlockQueryJDBCTemp.class.getName();
    private final DataSource dataSource;
    private JdbcUtil jdbcUtil;

    public BlockQueryJDBCTemp(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcUtil = new JdbcUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fetchDataAllCount(QueryConditonDatakey qcd) {
        Debug.logVerbose((String)("[JdonFramework]--> execute fetch all count for sql sentence: " + qcd.getSqlquery()), (String)module);
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        int ret = 0;
        try {
            c = this.dataSource.getConnection();
            ps = c.prepareStatement(qcd.getSqlquery(), 1004, 1007);
            this.jdbcUtil.setQueryParams(qcd.getQueryParams(), (PreparedStatement)ps);
            rs = ps.executeQuery();
            if (rs.first()) {
                ret = rs.getInt(1);
            }
        }
        catch (SQLException se) {
            Debug.logError((Throwable)se, (String)module);
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception ex) {}
        }
        Debug.logVerbose((String)("[JdonFramework]--> fetchDataAllCount is" + ret), (String)module);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List fetchDatas(QueryConditonDatakey qcdk) {
        Debug.logVerbose((String)("[JdonFramework]--> fetch the primary key collection, sql sentence: " + qcdk.getSQlKey()), (String)module);
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        int blockStart = qcdk.getBlockStart();
        int blockSize = qcdk.getBlockSize();
        Debug.logVerbose((String)("[JdonFramework]--> blockStart=" + blockStart + " blockSize=" + blockSize), (String)module);
        ArrayList<Object> items = new ArrayList<Object>(blockSize);
        try {
            c = this.dataSource.getConnection();
            DbUtil.testConnection((Connection)c);
            ps = c.prepareStatement(qcdk.getSqlquery(), 1004, 1007);
            this.jdbcUtil.setQueryParams(qcdk.getQueryParams(), (PreparedStatement)ps);
            rs = ps.executeQuery();
            if (DbUtil.supportsFetchSize) {
                rs.setFetchSize(blockSize);
            }
            for (int i = 0; i < blockStart && rs.next(); ++i) {
            }
            ++blockSize;
            while (rs.next() && --blockSize > 0) {
                Object result = rs.getObject(1);
                Debug.logVerbose((String)("[JdonFramework]--> found a primary key = " + result + ",  type:" + result.getClass().getName()), (String)module);
                items.add(result);
            }
            Debug.logVerbose((String)"[JdonFramework]--> get a result succefully ..", (String)module);
        }
        catch (SQLException se) {
            Debug.logError((Throwable)se, (String)module);
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)module);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception ex) {}
        }
        return items;
    }

    public JdbcUtil getJdbcUtil() {
        return this.jdbcUtil;
    }

    public void setJdbcUtil(JdbcUtil jdbcUtil) {
        this.jdbcUtil = jdbcUtil;
    }
}

