/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.security.ejb;

import com.jdon.util.Debug;
import java.security.Principal;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.SecurityAssociationHandler;

public class LoginClientUtil {
    private static final String module = LoginClientUtil.class.getName();

    public static boolean login(String username, String password, String Login_Module_Name) {
        Object subject = null;
        try {
            CallbackHandler pch = LoginClientUtil.getJBossCallbackHandler(username, password);
            LoginContext loginCtx = new LoginContext(Login_Module_Name, pch);
            Debug.logVerbose((String)"[JdonFramework] begin to login ", (String)module);
            loginCtx.login();
            Debug.logVerbose((String)("[JdonFramework] login successfully, subject=" + subject), (String)module);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Debug.logError((Throwable)e, (String)module);
            return false;
        }
    }

    private static CallbackHandler getJBossCallbackHandler(String username, String password) {
        SecurityAssociationHandler pch = new SecurityAssociationHandler();
        Principal user = LoginClientUtil.getJBossPrincipal(username);
        pch.setSecurityInfo(user, (Object)password.toCharArray());
        return pch;
    }

    private static Principal getJBossPrincipal(String username) {
        return new SimplePrincipal(username);
    }
}

