/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.security.web;

import com.jdon.controller.model.Model;
import com.jdon.controller.pool.Poolable;
import com.jdon.security.web.UserPrincipal;
import com.jdon.util.Debug;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class AbstractUserPrincipal
implements UserPrincipal,
Poolable {
    public static final String USERMODEL = "USERMODEL";
    private static final String module = AbstractUserPrincipal.class.getName();

    public Object getUserFromPrincipal(HttpServletRequest request) {
        Debug.logVerbose((String)"[JdonFramework]--> enter getUserFromPrincipal", (String)module);
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            Debug.logVerbose((String)"[JdonFramework]principal is null, not login by JAAS", (String)module);
            return null;
        }
        String username = principal.getName();
        Debug.logVerbose((String)("[JdonFramework]--> find the logined username=" + username), (String)module);
        HttpSession session = request.getSession();
        Object model = session.getAttribute(USERMODEL);
        if (model == null) {
            model = this.findUserModelIFByName(request, username);
            session.setAttribute(USERMODEL, model);
        }
        return model;
    }

    public void saveModeltoSession(HttpServletRequest request, Object model) {
        HttpSession session = request.getSession();
        session.setAttribute(USERMODEL, model);
    }

    public Object getUserFromSession(HttpServletRequest request) {
        Debug.logVerbose((String)"[JdonFramework]--> enter getUserFromSession", (String)module);
        HttpSession session = request.getSession();
        Object model = session.getAttribute(USERMODEL);
        return model;
    }

    public Object findUserModelIFByName(HttpServletRequest request, String key) {
        return this.findUserModelByName(request, key);
    }

    public abstract Model findUserModelByName(HttpServletRequest var1, String var2);
}

