/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.security.web;

import com.jdon.util.Debug;
import com.jdon.util.RequestUtil;
import com.jdon.util.StringUtil;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    private static final String module = CookieUtil.class.getName();

    public static void deleteAllCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie passCookie;
        Cookie userCookie;
        Cookie rememberMe = RequestUtil.getCookie((HttpServletRequest)request, (String)"rememberMe");
        if (rememberMe != null) {
            RequestUtil.deleteCookie((HttpServletResponse)response, (Cookie)rememberMe, (String)"/");
        }
        if ((userCookie = RequestUtil.getCookie((HttpServletRequest)request, (String)"username")) != null) {
            RequestUtil.deleteCookie((HttpServletResponse)response, (Cookie)userCookie, (String)"/");
        }
        if ((passCookie = RequestUtil.getCookie((HttpServletRequest)request, (String)"password")) != null) {
            RequestUtil.deleteCookie((HttpServletResponse)response, (Cookie)passCookie, (String)"/");
        }
    }

    public static void setUsername(HttpServletResponse response, String username) {
        RequestUtil.setCookie((HttpServletResponse)response, (String)"username", (String)StringUtil.encodeString((String)username), (String)"/");
    }

    public static String getUsername(HttpServletRequest request) {
        String username = "";
        try {
            Cookie userCookie = RequestUtil.getCookie((HttpServletRequest)request, (String)"username");
            username = userCookie != null ? StringUtil.decodeString((String)userCookie.getValue()) : null;
        }
        catch (Exception e) {
            System.err.print("getUsername from cookie" + e);
        }
        return username;
    }

    public static void setUPassword(HttpServletResponse response, String password) {
        RequestUtil.setCookie((HttpServletResponse)response, (String)"password", (String)StringUtil.encodeString((String)password), (String)"/");
    }

    public static String getPassword(HttpServletRequest request) {
        String password = "";
        try {
            Cookie passCookie = RequestUtil.getCookie((HttpServletRequest)request, (String)"password");
            password = passCookie != null ? StringUtil.decodeString((String)passCookie.getValue()) : null;
        }
        catch (Exception e) {
            System.err.print("getpassCookie from cookie" + e);
        }
        return password;
    }

    public static void setRememberMe(HttpServletResponse response) {
        RequestUtil.setCookie((HttpServletResponse)response, (String)"rememberMe", (String)"true", (String)"/");
    }

    public static String getRememberMe(HttpServletRequest request) {
        String rememberMe = "";
        try {
            Cookie rememberMeie = RequestUtil.getCookie((HttpServletRequest)request, (String)"rememberMe");
            rememberMe = rememberMeie != null ? URLDecoder.decode(rememberMeie.getValue(), "UTF-8") : null;
        }
        catch (Exception e) {
            System.err.print("getrememberMe from cookie" + e);
        }
        Debug.logVerbose((String)("[JdonFramework]--> get RememberMe from cookier :" + rememberMe), (String)module);
        return rememberMe;
    }
}

