/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.security.web;

import com.jdon.security.web.CookieUtil;
import com.jdon.util.Debug;
import com.jdon.util.RequestUtil;
import com.jdon.util.StringUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 9179143247292671107L;
    private static final String module = LoginServlet.class.getName();
    public static final String form_login_page_param = "login";
    public static final String form_error_page_param = "login_error";
    public static final String logout_param = "logout";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Debug.logVerbose((String)"[JdonFramework]enter LoginServlet", (String)module);
        this.initCharacterEncoding(request, response);
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (username != null && password != null) {
            Debug.logVerbose((String)"[JdonFramework] username and password is not null", (String)module);
            if (request.getParameter("rememberMe") != null) {
                this.saveCookie(username, password, request, response);
            } else {
                this.deleteAllCookie(request, response);
            }
        } else {
            Debug.logVerbose((String)"[JdonFramework] check cookie", (String)module);
            if (request.getParameterMap().containsKey(logout_param)) {
                this.logout(request, response);
                return;
            }
            username = CookieUtil.getUsername(request);
            password = CookieUtil.getPassword(request);
            Debug.logVerbose((String)("[JdonFramework]get username from cookie username=" + username), (String)module);
            if (username == null || password == null) {
                this.forwardLogin(request, response);
                return;
            }
        }
        String route = request.getContextPath() + "/j_security_check?j_username=" + username + "&j_password=" + password;
        Debug.logVerbose((String)("[JdonFramework] forward " + route), (String)module);
        response.sendRedirect(response.encodeRedirectURL(route));
    }

    private void initCharacterEncoding(HttpServletRequest request, HttpServletResponse response) {
        if (request.getCharacterEncoding() != null) {
            // empty if block
        }
    }

    private void saveCookie(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        Debug.logVerbose((String)"[JdonFramework] save cookie", (String)module);
        RequestUtil.setCookie((HttpServletResponse)response, (String)"rememberMe", (String)"true", (String)"/");
        RequestUtil.setCookie((HttpServletResponse)response, (String)"username", (String)StringUtil.encodeString((String)username), (String)"/");
        RequestUtil.setCookie((HttpServletResponse)response, (String)"password", (String)StringUtil.encodeString((String)password), (String)"/");
    }

    private void deleteAllCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie passCookie;
        Cookie userCookie;
        Cookie rememberMe = RequestUtil.getCookie((HttpServletRequest)request, (String)"rememberMe");
        if (rememberMe != null) {
            RequestUtil.deleteCookie((HttpServletResponse)response, (Cookie)rememberMe, (String)"/");
        }
        if ((userCookie = RequestUtil.getCookie((HttpServletRequest)request, (String)"username")) != null) {
            RequestUtil.deleteCookie((HttpServletResponse)response, (Cookie)userCookie, (String)"/");
        }
        if ((passCookie = RequestUtil.getCookie((HttpServletRequest)request, (String)"password")) != null) {
            RequestUtil.deleteCookie((HttpServletResponse)response, (Cookie)passCookie, (String)"/");
        }
    }

    private void logout(HttpServletRequest request, HttpServletResponse response) {
        Debug.logVerbose((String)"[JdonFramework]logout, session.invalidate ", (String)module);
        try {
            request.getSession().invalidate();
            this.deleteAllCookie(request, response);
            String logoutUrl = this.getInitParameter(logout_param);
            Debug.logVerbose((String)("[JdonFramework]delete all cookie, push logout jsp=" + logoutUrl), (String)module);
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + logoutUrl));
        }
        catch (IOException e) {
            Debug.logError((Throwable)e, (String)module);
        }
    }

    private void forwardLogin(HttpServletRequest request, HttpServletResponse response) {
        String loginUrl = this.getInitParameter(form_login_page_param);
        Debug.logVerbose((String)("[JdonFramework] not found cookie= push login jsp=" + loginUrl), (String)module);
        try {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + loginUrl));
        }
        catch (IOException e) {
            Debug.logError((Throwable)e, (String)module);
        }
    }
}

