/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.servicelocator.ejb;

import com.jdon.servicelocator.ServiceLocatorException;
import java.io.Serializable;
import java.net.URL;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;

public class ServiceLocator
implements Serializable {
    private static final long serialVersionUID = -9118735048187674303L;
    private InitialContext ic;

    public ServiceLocator() throws ServiceLocatorException {
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
    }

    public EJBLocalHome getLocalHome(String jndiHomeName) throws ServiceLocatorException {
        EJBLocalHome home = null;
        try {
            home = (EJBLocalHome)this.ic.lookup(jndiHomeName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return home;
    }

    public EJBHome getRemoteHome(String jndiHomeName, Class className) throws ServiceLocatorException {
        EJBHome home = null;
        try {
            Object objref = this.ic.lookup(jndiHomeName);
            Object obj = PortableRemoteObject.narrow((Object)objref, (Class)className);
            home = (EJBHome)obj;
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return home;
    }

    public QueueConnectionFactory getQueueConnectionFactory(String qConnFactoryName) throws ServiceLocatorException {
        QueueConnectionFactory factory = null;
        try {
            factory = (QueueConnectionFactory)this.ic.lookup(qConnFactoryName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return factory;
    }

    public Queue getQueue(String queueName) throws ServiceLocatorException {
        Queue queue = null;
        try {
            queue = (Queue)this.ic.lookup(queueName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return queue;
    }

    public TopicConnectionFactory getTopicConnectionFactory(String topicConnFactoryName) throws ServiceLocatorException {
        TopicConnectionFactory factory = null;
        try {
            factory = (TopicConnectionFactory)this.ic.lookup(topicConnFactoryName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return factory;
    }

    public Topic getTopic(String topicName) throws ServiceLocatorException {
        Topic topic = null;
        try {
            topic = (Topic)this.ic.lookup(topicName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return topic;
    }

    public DataSource getDataSource(String dataSourceName) throws ServiceLocatorException {
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)this.ic.lookup(dataSourceName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return dataSource;
    }

    public URL getUrl(String envName) throws ServiceLocatorException {
        URL url = null;
        try {
            url = (URL)this.ic.lookup(envName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return url;
    }

    public boolean getBoolean(String envName) throws ServiceLocatorException {
        Boolean bool = null;
        try {
            bool = (Boolean)this.ic.lookup(envName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return bool;
    }

    public String getString(String envName) throws ServiceLocatorException {
        String envEntry = null;
        try {
            envEntry = (String)this.ic.lookup(envName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return envEntry;
    }

    public Object getDAO(String jndiDAOName) throws ServiceLocatorException {
        Object object = null;
        try {
            String className = (String)this.ic.lookup(jndiDAOName);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            object = classLoader.loadClass(className).newInstance();
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception se) {
            throw new ServiceLocatorException(se);
        }
        return object;
    }
}

