/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.servicelocator.web;

import com.jdon.container.pico.Startable;
import com.jdon.servicelocator.ServiceLocatorException;
import com.jdon.util.Debug;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;

public class ServiceLocator
implements Startable {
    private static final String module = ServiceLocator.class.getName();
    private InitialContext ic;
    private Map cache;

    public ServiceLocator() {
        try {
            this.ic = new InitialContext();
            this.cache = new ConcurrentHashMap();
        }
        catch (NamingException ne) {
            System.err.print("NamingException error: " + ne);
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }

    public void start() {
        Debug.logVerbose((String)"[JdonFramework]ServiceLocator start .....", (String)module);
        this.cache.clear();
    }

    public void stop() {
        this.cache.clear();
    }

    public EJBLocalHome getLocalHome(String jndiHomeName) throws ServiceLocatorException {
        Debug.logVerbose((String)"[JdonFramework] -- > getLocalHome.... ", (String)module);
        EJBLocalHome home = null;
        try {
            if (this.cache.containsKey(jndiHomeName)) {
                home = (EJBLocalHome)this.cache.get(jndiHomeName);
            } else {
                Debug.logVerbose((String)"[JdonFramework]  lookUp LocalHome.... ", (String)module);
                home = (EJBLocalHome)this.ic.lookup(jndiHomeName);
                this.cache.put(jndiHomeName, home);
            }
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return home;
    }

    public EJBHome getRemoteHome(String jndiHomeName, Class className) throws ServiceLocatorException {
        EJBHome home = null;
        try {
            if (this.cache.containsKey(jndiHomeName)) {
                home = (EJBHome)this.cache.get(jndiHomeName);
            } else {
                Object objref = this.ic.lookup(jndiHomeName);
                Object obj = PortableRemoteObject.narrow((Object)objref, (Class)className);
                home = (EJBHome)obj;
                this.cache.put(jndiHomeName, home);
            }
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return home;
    }

    public QueueConnectionFactory getQueueConnectionFactory(String qConnFactoryName) throws ServiceLocatorException {
        QueueConnectionFactory factory = null;
        try {
            if (this.cache.containsKey(qConnFactoryName)) {
                factory = (QueueConnectionFactory)this.cache.get(qConnFactoryName);
            } else {
                factory = (QueueConnectionFactory)this.ic.lookup(qConnFactoryName);
                this.cache.put(qConnFactoryName, factory);
            }
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return factory;
    }

    public Queue getQueue(String queueName) throws ServiceLocatorException {
        Queue queue = null;
        try {
            if (this.cache.containsKey(queueName)) {
                queue = (Queue)this.cache.get(queueName);
            } else {
                queue = (Queue)this.ic.lookup(queueName);
                this.cache.put(queueName, queue);
            }
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return queue;
    }

    public TopicConnectionFactory getTopicConnectionFactory(String topicConnFactoryName) throws ServiceLocatorException {
        TopicConnectionFactory factory = null;
        try {
            if (this.cache.containsKey(topicConnFactoryName)) {
                factory = (TopicConnectionFactory)this.cache.get(topicConnFactoryName);
            } else {
                factory = (TopicConnectionFactory)this.ic.lookup(topicConnFactoryName);
                this.cache.put(topicConnFactoryName, factory);
            }
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return factory;
    }

    public Topic getTopic(String topicName) throws ServiceLocatorException {
        Topic topic = null;
        try {
            if (this.cache.containsKey(topicName)) {
                topic = (Topic)this.cache.get(topicName);
            } else {
                topic = (Topic)this.ic.lookup(topicName);
                this.cache.put(topicName, topic);
            }
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return topic;
    }

    public DataSource getDataSource(String dataSourceName) throws ServiceLocatorException {
        DataSource dataSource = null;
        try {
            if (this.cache.containsKey(dataSourceName)) {
                dataSource = (DataSource)this.cache.get(dataSourceName);
            } else {
                dataSource = (DataSource)this.ic.lookup(dataSourceName);
                this.cache.put(dataSourceName, dataSource);
            }
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return dataSource;
    }

    public URL getUrl(String envName) throws ServiceLocatorException {
        URL url = null;
        try {
            url = (URL)this.ic.lookup(envName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return url;
    }

    public boolean getBoolean(String envName) throws ServiceLocatorException {
        Boolean bool = null;
        try {
            bool = (Boolean)this.ic.lookup(envName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return bool;
    }

    public String getString(String envName) throws ServiceLocatorException {
        String envEntry = null;
        try {
            envEntry = (String)this.ic.lookup(envName);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception e) {
            throw new ServiceLocatorException(e);
        }
        return envEntry;
    }

    public Object getDAO(String jndiDAOName) throws ServiceLocatorException {
        Object object = null;
        try {
            String className = (String)this.ic.lookup(jndiDAOName);
            object = Class.forName(className).newInstance();
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        catch (Exception se) {
            throw new ServiceLocatorException(se);
        }
        return object;
    }
}

