/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.RetweetDetails;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Comment
extends WeiboResponse
implements Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private RetweetDetails retweetDetails;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Comment(Response res, Weibo weibo) throws WeiboException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(res, elem, weibo);
    }

    Comment(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getLong("id");
            this.text = json.getString("text");
            this.source = json.getString("source");
            this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Comment(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getLong("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        if (!json.isNull("user")) {
            this.user = new User(json.getJSONObject("user"));
        }
    }

    Comment(Response res, Element elem, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, elem, weibo);
    }

    public Comment(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.id = json.getLong("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.user = new User(json.getJSONObject("user"));
    }

    private void init(Response res, Element elem, Weibo weibo) throws WeiboException {
        Comment.ensureRootNodeNameIs("comment", elem);
        this.user = new User(res, (Element)elem.getElementsByTagName("user").item(0), weibo);
        this.id = Comment.getChildLong("id", elem);
        this.text = Comment.getChildText("text", elem);
        this.source = Comment.getChildText("source", elem);
        this.createdAt = Comment.getChildDate("created_at", elem);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isRetweet() {
        return this.retweetDetails != null;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    static List<Comment> constructComments(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (Comment.isRootNodeNilClasses(doc)) {
            return new ArrayList<Comment>(0);
        }
        try {
            Comment.ensureRootNodeNameIs("comments", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("comment");
            int size = list.getLength();
            ArrayList<Comment> statuses = new ArrayList<Comment>(size);
            int i = 0;
            while (i < size) {
                Element status = (Element)list.item(i);
                statuses.add(new Comment(res, status, weibo));
                ++i;
            }
            return statuses;
        }
        catch (WeiboException te) {
            Comment.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Comment>(0);
        }
    }

    static List<Comment> constructComments(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Comment> comments = new ArrayList<Comment>(size);
            int i = 0;
            while (i < size) {
                comments.add(new Comment(list.getJSONObject(i)));
                ++i;
            }
            return comments;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Comment other = (Comment)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "Comment{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", retweetDetails=" + this.retweetDetails + ", user=" + this.user + '}';
    }
}

